/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// RouteTable : Information about the route table.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct RouteTable {
    /// One or more associations between the route table and Subnets.
    #[serde(rename = "LinkRouteTables", skip_serializing_if = "Option::is_none")]
    pub link_route_tables: Option<Vec<crate::models::LinkRouteTable>>,
    /// The ID of the Net for the route table.
    #[serde(rename = "NetId", skip_serializing_if = "Option::is_none")]
    pub net_id: Option<String>,
    /// Information about virtual gateways propagating routes.
    #[serde(
        rename = "RoutePropagatingVirtualGateways",
        skip_serializing_if = "Option::is_none"
    )]
    pub route_propagating_virtual_gateways:
        Option<Vec<crate::models::RoutePropagatingVirtualGateway>>,
    /// The ID of the route table.
    #[serde(rename = "RouteTableId", skip_serializing_if = "Option::is_none")]
    pub route_table_id: Option<String>,
    /// One or more routes in the route table.
    #[serde(rename = "Routes", skip_serializing_if = "Option::is_none")]
    pub routes: Option<Vec<crate::models::Route>>,
    /// One or more tags associated with the route table.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
}

impl RouteTable {
    /// Information about the route table.
    pub fn new() -> RouteTable {
        RouteTable {
            link_route_tables: None,
            net_id: None,
            route_propagating_virtual_gateways: None,
            route_table_id: None,
            routes: None,
            tags: None,
        }
    }
}
