/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// RouteLight : Information about the route.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct RouteLight {
    /// The IP range used for the destination match, in CIDR notation (for example, 10.0.0.0/24).
    #[serde(rename = "DestinationIpRange", skip_serializing_if = "Option::is_none")]
    pub destination_ip_range: Option<String>,
    /// The type of route (always `static`).
    #[serde(rename = "RouteType", skip_serializing_if = "Option::is_none")]
    pub route_type: Option<String>,
    /// The current state of the static route (`pending` \\| `available` \\| `deleting` \\| `deleted`).
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}

impl RouteLight {
    /// Information about the route.
    pub fn new() -> RouteLight {
        RouteLight {
            destination_ip_range: None,
            route_type: None,
            state: None,
        }
    }
}
