/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// ResourceTag : Information about the tag.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ResourceTag {
    /// The key of the tag, with a minimum of 1 character.
    #[serde(rename = "Key")]
    pub key: String,
    /// The value of the tag, between 0 and 255 characters.
    #[serde(rename = "Value")]
    pub value: String,
}

impl ResourceTag {
    /// Information about the tag.
    pub fn new(key: String, value: String) -> ResourceTag {
        ResourceTag { key, value }
    }
}
