/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// Quota : Information about the quota.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Quota {
    /// The account ID of the owner of the quotas.
    #[serde(rename = "AccountId", skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// The description of the quota.
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The maximum value of the quota for the OUTSCALE user account (if there is no limit, `0`).
    #[serde(rename = "MaxValue", skip_serializing_if = "Option::is_none")]
    pub max_value: Option<i32>,
    /// The unique name of the quota.
    #[serde(rename = "Name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The group name of the quota.
    #[serde(rename = "QuotaCollection", skip_serializing_if = "Option::is_none")]
    pub quota_collection: Option<String>,
    /// The description of the quota.
    #[serde(rename = "ShortDescription", skip_serializing_if = "Option::is_none")]
    pub short_description: Option<String>,
    /// The limit value currently used by the OUTSCALE user account.
    #[serde(rename = "UsedValue", skip_serializing_if = "Option::is_none")]
    pub used_value: Option<i32>,
}

impl Quota {
    /// Information about the quota.
    pub fn new() -> Quota {
        Quota {
            account_id: None,
            description: None,
            max_value: None,
            name: None,
            quota_collection: None,
            short_description: None,
            used_value: None,
        }
    }
}
