/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// PublicIp : Information about the public IP.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct PublicIp {
    /// (Required in a Net) The ID representing the association of the public IP with the VM or the NIC.
    #[serde(rename = "LinkPublicIpId", skip_serializing_if = "Option::is_none")]
    pub link_public_ip_id: Option<String>,
    /// The account ID of the owner of the NIC.
    #[serde(rename = "NicAccountId", skip_serializing_if = "Option::is_none")]
    pub nic_account_id: Option<String>,
    /// The ID of the NIC the public IP is associated with (if any).
    #[serde(rename = "NicId", skip_serializing_if = "Option::is_none")]
    pub nic_id: Option<String>,
    /// The private IP associated with the public IP.
    #[serde(rename = "PrivateIp", skip_serializing_if = "Option::is_none")]
    pub private_ip: Option<String>,
    /// The public IP.
    #[serde(rename = "PublicIp", skip_serializing_if = "Option::is_none")]
    pub public_ip: Option<String>,
    /// The allocation ID of the public IP.
    #[serde(rename = "PublicIpId", skip_serializing_if = "Option::is_none")]
    pub public_ip_id: Option<String>,
    /// One or more tags associated with the public IP.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
    /// The ID of the VM the public IP is associated with (if any).
    #[serde(rename = "VmId", skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
}

impl PublicIp {
    /// Information about the public IP.
    pub fn new() -> PublicIp {
        PublicIp {
            link_public_ip_id: None,
            nic_account_id: None,
            nic_id: None,
            private_ip: None,
            public_ip: None,
            public_ip_id: None,
            tags: None,
            vm_id: None,
        }
    }
}
