/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// ProductType : Information about the product type.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ProductType {
    /// The description of the product type.
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The ID of the product type.
    #[serde(rename = "ProductTypeId", skip_serializing_if = "Option::is_none")]
    pub product_type_id: Option<String>,
    /// The vendor of the product type.
    #[serde(rename = "Vendor", skip_serializing_if = "Option::is_none")]
    pub vendor: Option<String>,
}

impl ProductType {
    /// Information about the product type.
    pub fn new() -> ProductType {
        ProductType {
            description: None,
            product_type_id: None,
            vendor: None,
        }
    }
}
