/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// NetPeering : Information about the Net peering connection.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct NetPeering {
    #[serde(rename = "AccepterNet", skip_serializing_if = "Option::is_none")]
    pub accepter_net: Option<Box<crate::models::AccepterNet>>,
    /// The ID of the Net peering connection.
    #[serde(rename = "NetPeeringId", skip_serializing_if = "Option::is_none")]
    pub net_peering_id: Option<String>,
    #[serde(rename = "SourceNet", skip_serializing_if = "Option::is_none")]
    pub source_net: Option<Box<crate::models::SourceNet>>,
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<Box<crate::models::NetPeeringState>>,
    /// One or more tags associated with the Net peering connection.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
}

impl NetPeering {
    /// Information about the Net peering connection.
    pub fn new() -> NetPeering {
        NetPeering {
            accepter_net: None,
            net_peering_id: None,
            source_net: None,
            state: None,
            tags: None,
        }
    }
}
