/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// NetAccessPoint : Information about the Net access point.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct NetAccessPoint {
    /// The ID of the Net access point.
    #[serde(rename = "NetAccessPointId", skip_serializing_if = "Option::is_none")]
    pub net_access_point_id: Option<String>,
    /// The ID of the Net with which the Net access point is associated.
    #[serde(rename = "NetId", skip_serializing_if = "Option::is_none")]
    pub net_id: Option<String>,
    /// The ID of the route tables associated with the Net access point.
    #[serde(rename = "RouteTableIds", skip_serializing_if = "Option::is_none")]
    pub route_table_ids: Option<Vec<String>>,
    /// The name of the service with which the Net access point is associated.
    #[serde(rename = "ServiceName", skip_serializing_if = "Option::is_none")]
    pub service_name: Option<String>,
    /// The state of the Net access point (`pending` \\| `available` \\| `deleting` \\| `deleted`).
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    /// One or more tags associated with the Net access point.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
}

impl NetAccessPoint {
    /// Information about the Net access point.
    pub fn new() -> NetAccessPoint {
        NetAccessPoint {
            net_access_point_id: None,
            net_id: None,
            route_table_ids: None,
            service_name: None,
            state: None,
            tags: None,
        }
    }
}
