/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// NatService : Information about the NAT service.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct NatService {
    /// The ID of the NAT service.
    #[serde(rename = "NatServiceId", skip_serializing_if = "Option::is_none")]
    pub nat_service_id: Option<String>,
    /// The ID of the Net in which the NAT service is.
    #[serde(rename = "NetId", skip_serializing_if = "Option::is_none")]
    pub net_id: Option<String>,
    /// Information about the public IP or IPs associated with the NAT service.
    #[serde(rename = "PublicIps", skip_serializing_if = "Option::is_none")]
    pub public_ips: Option<Vec<crate::models::PublicIpLight>>,
    /// The state of the NAT service (`pending` \\| `available` \\| `deleting` \\| `deleted`).
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    /// The ID of the Subnet in which the NAT service is.
    #[serde(rename = "SubnetId", skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    /// One or more tags associated with the NAT service.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
}

impl NatService {
    /// Information about the NAT service.
    pub fn new() -> NatService {
        NatService {
            nat_service_id: None,
            net_id: None,
            public_ips: None,
            state: None,
            subnet_id: None,
            tags: None,
        }
    }
}
