/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// LoadBalancer : Information about the load balancer.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct LoadBalancer {
    #[serde(rename = "AccessLog", skip_serializing_if = "Option::is_none")]
    pub access_log: Option<Box<crate::models::AccessLog>>,
    /// The stickiness policies defined for the load balancer.
    #[serde(
        rename = "ApplicationStickyCookiePolicies",
        skip_serializing_if = "Option::is_none"
    )]
    pub application_sticky_cookie_policies:
        Option<Vec<crate::models::ApplicationStickyCookiePolicy>>,
    /// One or more public IPs of back-end VMs.
    #[serde(rename = "BackendIps", skip_serializing_if = "Option::is_none")]
    pub backend_ips: Option<Vec<String>>,
    /// One or more IDs of back-end VMs for the load balancer.
    #[serde(rename = "BackendVmIds", skip_serializing_if = "Option::is_none")]
    pub backend_vm_ids: Option<Vec<String>>,
    /// The DNS name of the load balancer.
    #[serde(rename = "DnsName", skip_serializing_if = "Option::is_none")]
    pub dns_name: Option<String>,
    #[serde(rename = "HealthCheck", skip_serializing_if = "Option::is_none")]
    pub health_check: Option<Box<crate::models::HealthCheck>>,
    /// The listeners for the load balancer.
    #[serde(rename = "Listeners", skip_serializing_if = "Option::is_none")]
    pub listeners: Option<Vec<crate::models::Listener>>,
    /// The name of the load balancer.
    #[serde(rename = "LoadBalancerName", skip_serializing_if = "Option::is_none")]
    pub load_balancer_name: Option<String>,
    /// The policies defined for the load balancer.
    #[serde(
        rename = "LoadBalancerStickyCookiePolicies",
        skip_serializing_if = "Option::is_none"
    )]
    pub load_balancer_sticky_cookie_policies:
        Option<Vec<crate::models::LoadBalancerStickyCookiePolicy>>,
    /// The type of load balancer. Valid only for load balancers in a Net.<br /> If `LoadBalancerType` is `internet-facing`, the load balancer has a public DNS name that resolves to a public IP.<br /> If `LoadBalancerType` is `internal`, the load balancer has a public DNS name that resolves to a private IP.
    #[serde(rename = "LoadBalancerType", skip_serializing_if = "Option::is_none")]
    pub load_balancer_type: Option<String>,
    /// The ID of the Net for the load balancer.
    #[serde(rename = "NetId", skip_serializing_if = "Option::is_none")]
    pub net_id: Option<String>,
    /// (internet-facing only) The public IP associated with the load balancer.
    #[serde(rename = "PublicIp", skip_serializing_if = "Option::is_none")]
    pub public_ip: Option<String>,
    /// One or more IDs of security groups for the load balancers. Valid only for load balancers in a Net.
    #[serde(rename = "SecurityGroups", skip_serializing_if = "Option::is_none")]
    pub security_groups: Option<Vec<String>>,
    #[serde(
        rename = "SourceSecurityGroup",
        skip_serializing_if = "Option::is_none"
    )]
    pub source_security_group: Option<Box<crate::models::SourceSecurityGroup>>,
    /// The ID of the Subnet in which the load balancer was created.
    #[serde(rename = "Subnets", skip_serializing_if = "Option::is_none")]
    pub subnets: Option<Vec<String>>,
    /// The ID of the Subregion in which the load balancer was created.
    #[serde(rename = "SubregionNames", skip_serializing_if = "Option::is_none")]
    pub subregion_names: Option<Vec<String>>,
    /// One or more tags associated with the load balancer.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
}

impl LoadBalancer {
    /// Information about the load balancer.
    pub fn new() -> LoadBalancer {
        LoadBalancer {
            access_log: None,
            application_sticky_cookie_policies: None,
            backend_ips: None,
            backend_vm_ids: None,
            dns_name: None,
            health_check: None,
            listeners: None,
            load_balancer_name: None,
            load_balancer_sticky_cookie_policies: None,
            load_balancer_type: None,
            net_id: None,
            public_ip: None,
            security_groups: None,
            source_security_group: None,
            subnets: None,
            subregion_names: None,
            tags: None,
        }
    }
}
