/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct LinkNicRequest {
    /// The index of the VM device for the NIC attachment (between 1 and 7, both included).
    #[serde(rename = "DeviceNumber")]
    pub device_number: i32,
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The ID of the NIC you want to attach.
    #[serde(rename = "NicId")]
    pub nic_id: String,
    /// The ID of the VM to which you want to attach the NIC.
    #[serde(rename = "VmId")]
    pub vm_id: String,
}

impl LinkNicRequest {
    pub fn new(device_number: i32, nic_id: String, vm_id: String) -> LinkNicRequest {
        LinkNicRequest {
            device_number,
            dry_run: None,
            nic_id,
            vm_id,
        }
    }
}
