/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// Keypair : Information about the keypair.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Keypair {
    /// The MD5 public key fingerprint as specified in section 4 of RFC 4716.
    #[serde(rename = "KeypairFingerprint", skip_serializing_if = "Option::is_none")]
    pub keypair_fingerprint: Option<String>,
    /// The name of the keypair.
    #[serde(rename = "KeypairName", skip_serializing_if = "Option::is_none")]
    pub keypair_name: Option<String>,
}

impl Keypair {
    /// Information about the keypair.
    pub fn new() -> Keypair {
        Keypair {
            keypair_fingerprint: None,
            keypair_name: None,
        }
    }
}
