/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// HealthCheck : Information about the health check configuration.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct HealthCheck {
    /// The number of seconds between two pings (between `5` and `600` both included).
    #[serde(rename = "CheckInterval")]
    pub check_interval: i32,
    /// The number of consecutive successful pings before considering the VM as healthy (between `2` and `10` both included).
    #[serde(rename = "HealthyThreshold")]
    pub healthy_threshold: i32,
    /// If you use the HTTP or HTTPS protocols, the ping path.
    #[serde(rename = "Path", skip_serializing_if = "Option::is_none")]
    pub path: Option<String>,
    /// The port number (between `1` and `65535`, both included).
    #[serde(rename = "Port")]
    pub port: i32,
    /// The protocol for the URL of the VM (`HTTP` \\| `HTTPS` \\| `TCP` \\| `SSL`).
    #[serde(rename = "Protocol")]
    pub protocol: String,
    /// The maximum waiting time for a response before considering the VM as unhealthy, in seconds (between `2` and `60` both included).
    #[serde(rename = "Timeout")]
    pub timeout: i32,
    /// The number of consecutive failed pings before considering the VM as unhealthy (between `2` and `10` both included).
    #[serde(rename = "UnhealthyThreshold")]
    pub unhealthy_threshold: i32,
}

impl HealthCheck {
    /// Information about the health check configuration.
    pub fn new(
        check_interval: i32,
        healthy_threshold: i32,
        port: i32,
        protocol: String,
        timeout: i32,
        unhealthy_threshold: i32,
    ) -> HealthCheck {
        HealthCheck {
            check_interval,
            healthy_threshold,
            path: None,
            port,
            protocol,
            timeout,
            unhealthy_threshold,
        }
    }
}
