/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersVolume : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersVolume {
    /// The dates and times at which the volumes were created.
    #[serde(rename = "CreationDates", skip_serializing_if = "Option::is_none")]
    pub creation_dates: Option<Vec<String>>,
    /// Whether the volumes are deleted or not when terminating the VMs.
    #[serde(
        rename = "LinkVolumeDeleteOnVmDeletion",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_volume_delete_on_vm_deletion: Option<bool>,
    /// The VM device names.
    #[serde(
        rename = "LinkVolumeDeviceNames",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_volume_device_names: Option<Vec<String>>,
    /// The dates and times at which the volumes were created.
    #[serde(
        rename = "LinkVolumeLinkDates",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_volume_link_dates: Option<Vec<String>>,
    /// The attachment states of the volumes (`attaching` \\| `detaching` \\| `attached` \\| `detached`).
    #[serde(
        rename = "LinkVolumeLinkStates",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_volume_link_states: Option<Vec<String>>,
    /// One or more IDs of VMs.
    #[serde(rename = "LinkVolumeVmIds", skip_serializing_if = "Option::is_none")]
    pub link_volume_vm_ids: Option<Vec<String>>,
    /// The snapshots from which the volumes were created.
    #[serde(rename = "SnapshotIds", skip_serializing_if = "Option::is_none")]
    pub snapshot_ids: Option<Vec<String>>,
    /// The names of the Subregions in which the volumes were created.
    #[serde(rename = "SubregionNames", skip_serializing_if = "Option::is_none")]
    pub subregion_names: Option<Vec<String>>,
    /// The keys of the tags associated with the volumes.
    #[serde(rename = "TagKeys", skip_serializing_if = "Option::is_none")]
    pub tag_keys: Option<Vec<String>>,
    /// The values of the tags associated with the volumes.
    #[serde(rename = "TagValues", skip_serializing_if = "Option::is_none")]
    pub tag_values: Option<Vec<String>>,
    /// The key/value combination of the tags associated with the volumes, in the following format: &quot;Filters&quot;:{&quot;Tags&quot;:[&quot;TAGKEY=TAGVALUE&quot;]}.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// The IDs of the volumes.
    #[serde(rename = "VolumeIds", skip_serializing_if = "Option::is_none")]
    pub volume_ids: Option<Vec<String>>,
    /// The sizes of the volumes, in gibibytes (GiB).
    #[serde(rename = "VolumeSizes", skip_serializing_if = "Option::is_none")]
    pub volume_sizes: Option<Vec<i32>>,
    /// The states of the volumes (`creating` \\| `available` \\| `in-use` \\| `updating` \\| `deleting` \\| `error`).
    #[serde(rename = "VolumeStates", skip_serializing_if = "Option::is_none")]
    pub volume_states: Option<Vec<String>>,
    /// The types of the volumes (`standard` \\| `gp2` \\| `io1`).
    #[serde(rename = "VolumeTypes", skip_serializing_if = "Option::is_none")]
    pub volume_types: Option<Vec<String>>,
}

impl FiltersVolume {
    /// One or more filters.
    pub fn new() -> FiltersVolume {
        FiltersVolume {
            creation_dates: None,
            link_volume_delete_on_vm_deletion: None,
            link_volume_device_names: None,
            link_volume_link_dates: None,
            link_volume_link_states: None,
            link_volume_vm_ids: None,
            snapshot_ids: None,
            subregion_names: None,
            tag_keys: None,
            tag_values: None,
            tags: None,
            volume_ids: None,
            volume_sizes: None,
            volume_states: None,
            volume_types: None,
        }
    }
}
