/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersVmsState : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersVmsState {
    /// The code for the scheduled event (`system-reboot` \\| `system-maintenance`).
    #[serde(
        rename = "MaintenanceEventCodes",
        skip_serializing_if = "Option::is_none"
    )]
    pub maintenance_event_codes: Option<Vec<String>>,
    /// The description of the scheduled event.
    #[serde(
        rename = "MaintenanceEventDescriptions",
        skip_serializing_if = "Option::is_none"
    )]
    pub maintenance_event_descriptions: Option<Vec<String>>,
    /// The latest time the event can end.
    #[serde(
        rename = "MaintenanceEventsNotAfter",
        skip_serializing_if = "Option::is_none"
    )]
    pub maintenance_events_not_after: Option<Vec<String>>,
    /// The earliest time the event can start.
    #[serde(
        rename = "MaintenanceEventsNotBefore",
        skip_serializing_if = "Option::is_none"
    )]
    pub maintenance_events_not_before: Option<Vec<String>>,
    /// The names of the Subregions of the VMs.
    #[serde(rename = "SubregionNames", skip_serializing_if = "Option::is_none")]
    pub subregion_names: Option<Vec<String>>,
    /// One or more IDs of VMs.
    #[serde(rename = "VmIds", skip_serializing_if = "Option::is_none")]
    pub vm_ids: Option<Vec<String>>,
    /// The states of the VMs (`pending` \\| `running` \\| `stopping` \\| `stopped` \\| `shutting-down` \\| `terminated` \\| `quarantine`).
    #[serde(rename = "VmStates", skip_serializing_if = "Option::is_none")]
    pub vm_states: Option<Vec<String>>,
}

impl FiltersVmsState {
    /// One or more filters.
    pub fn new() -> FiltersVmsState {
        FiltersVmsState {
            maintenance_event_codes: None,
            maintenance_event_descriptions: None,
            maintenance_events_not_after: None,
            maintenance_events_not_before: None,
            subregion_names: None,
            vm_ids: None,
            vm_states: None,
        }
    }
}
