/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersTag : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersTag {
    /// The keys of the tags that are assigned to the resources. You can use this filter alongside the `Values` filter. In that case, you filter the resources corresponding to each tag, regardless of the other filter.
    #[serde(rename = "Keys", skip_serializing_if = "Option::is_none")]
    pub keys: Option<Vec<String>>,
    /// The IDs of the resources with which the tags are associated.
    #[serde(rename = "ResourceIds", skip_serializing_if = "Option::is_none")]
    pub resource_ids: Option<Vec<String>>,
    /// The resource type (`vm` \\| `image` \\| `volume` \\| `snapshot` \\| `public-ip` \\| `security-group` \\| `route-table` \\| `nic` \\| `net` \\| `subnet` \\| `net-peering` \\| `net-access-point` \\| `nat-service` \\| `internet-service` \\| `client-gateway` \\| `virtual-gateway` \\| `vpn-connection` \\| `dhcp-options` \\| `task`).
    #[serde(rename = "ResourceTypes", skip_serializing_if = "Option::is_none")]
    pub resource_types: Option<Vec<String>>,
    /// The values of the tags that are assigned to the resources. You can use this filter alongside the `TagKeys` filter. In that case, you filter the resources corresponding to each tag, regardless of the other filter.
    #[serde(rename = "Values", skip_serializing_if = "Option::is_none")]
    pub values: Option<Vec<String>>,
}

impl FiltersTag {
    /// One or more filters.
    pub fn new() -> FiltersTag {
        FiltersTag {
            keys: None,
            resource_ids: None,
            resource_types: None,
            values: None,
        }
    }
}
