/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersPublicIp : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersPublicIp {
    /// The IDs representing the associations of public IPs with VMs or NICs.
    #[serde(rename = "LinkPublicIpIds", skip_serializing_if = "Option::is_none")]
    pub link_public_ip_ids: Option<Vec<String>>,
    /// The account IDs of the owners of the NICs.
    #[serde(rename = "NicAccountIds", skip_serializing_if = "Option::is_none")]
    pub nic_account_ids: Option<Vec<String>>,
    /// The IDs of the NICs.
    #[serde(rename = "NicIds", skip_serializing_if = "Option::is_none")]
    pub nic_ids: Option<Vec<String>>,
    /// Whether the public IPs are for use in the public Cloud or in a Net.
    #[serde(rename = "Placements", skip_serializing_if = "Option::is_none")]
    pub placements: Option<Vec<String>>,
    /// The private IPs associated with the public IPs.
    #[serde(rename = "PrivateIps", skip_serializing_if = "Option::is_none")]
    pub private_ips: Option<Vec<String>>,
    /// The IDs of the public IPs.
    #[serde(rename = "PublicIpIds", skip_serializing_if = "Option::is_none")]
    pub public_ip_ids: Option<Vec<String>>,
    /// The public IPs.
    #[serde(rename = "PublicIps", skip_serializing_if = "Option::is_none")]
    pub public_ips: Option<Vec<String>>,
    /// The keys of the tags associated with the public IPs.
    #[serde(rename = "TagKeys", skip_serializing_if = "Option::is_none")]
    pub tag_keys: Option<Vec<String>>,
    /// The values of the tags associated with the public IPs.
    #[serde(rename = "TagValues", skip_serializing_if = "Option::is_none")]
    pub tag_values: Option<Vec<String>>,
    /// The key/value combination of the tags associated with the public IPs, in the following format: &quot;Filters&quot;:{&quot;Tags&quot;:[&quot;TAGKEY=TAGVALUE&quot;]}.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// The IDs of the VMs.
    #[serde(rename = "VmIds", skip_serializing_if = "Option::is_none")]
    pub vm_ids: Option<Vec<String>>,
}

impl FiltersPublicIp {
    /// One or more filters.
    pub fn new() -> FiltersPublicIp {
        FiltersPublicIp {
            link_public_ip_ids: None,
            nic_account_ids: None,
            nic_ids: None,
            placements: None,
            private_ips: None,
            public_ip_ids: None,
            public_ips: None,
            tag_keys: None,
            tag_values: None,
            tags: None,
            vm_ids: None,
        }
    }
}
