/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersNic : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersNic {
    /// The descriptions of the NICs.
    #[serde(rename = "Descriptions", skip_serializing_if = "Option::is_none")]
    pub descriptions: Option<Vec<String>>,
    /// Whether the source/destination checking is enabled (true) or disabled (false).
    #[serde(rename = "IsSourceDestCheck", skip_serializing_if = "Option::is_none")]
    pub is_source_dest_check: Option<bool>,
    /// Whether the NICs are deleted when the VMs they are attached to are terminated.
    #[serde(
        rename = "LinkNicDeleteOnVmDeletion",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_nic_delete_on_vm_deletion: Option<bool>,
    /// The device numbers the NICs are attached to.
    #[serde(
        rename = "LinkNicDeviceNumbers",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_nic_device_numbers: Option<Vec<i32>>,
    /// The attachment IDs of the NICs.
    #[serde(rename = "LinkNicLinkNicIds", skip_serializing_if = "Option::is_none")]
    pub link_nic_link_nic_ids: Option<Vec<String>>,
    /// The states of the attachments.
    #[serde(rename = "LinkNicStates", skip_serializing_if = "Option::is_none")]
    pub link_nic_states: Option<Vec<String>>,
    /// The account IDs of the owners of the VMs the NICs are attached to.
    #[serde(
        rename = "LinkNicVmAccountIds",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_nic_vm_account_ids: Option<Vec<String>>,
    /// The IDs of the VMs the NICs are attached to.
    #[serde(rename = "LinkNicVmIds", skip_serializing_if = "Option::is_none")]
    pub link_nic_vm_ids: Option<Vec<String>>,
    /// The account IDs of the owners of the public IPs associated with the NICs.
    #[serde(
        rename = "LinkPublicIpAccountIds",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_public_ip_account_ids: Option<Vec<String>>,
    /// The association IDs returned when the public IPs were associated with the NICs.
    #[serde(
        rename = "LinkPublicIpLinkPublicIpIds",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_public_ip_link_public_ip_ids: Option<Vec<String>>,
    /// The allocation IDs returned when the public IPs were allocated to their accounts.
    #[serde(
        rename = "LinkPublicIpPublicIpIds",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_public_ip_public_ip_ids: Option<Vec<String>>,
    /// The public IPs associated with the NICs.
    #[serde(
        rename = "LinkPublicIpPublicIps",
        skip_serializing_if = "Option::is_none"
    )]
    pub link_public_ip_public_ips: Option<Vec<String>>,
    /// The Media Access Control (MAC) addresses of the NICs.
    #[serde(rename = "MacAddresses", skip_serializing_if = "Option::is_none")]
    pub mac_addresses: Option<Vec<String>>,
    /// The IDs of the Nets where the NICs are located.
    #[serde(rename = "NetIds", skip_serializing_if = "Option::is_none")]
    pub net_ids: Option<Vec<String>>,
    /// The IDs of the NICs.
    #[serde(rename = "NicIds", skip_serializing_if = "Option::is_none")]
    pub nic_ids: Option<Vec<String>>,
    /// The private DNS names associated with the primary private IPs.
    #[serde(rename = "PrivateDnsNames", skip_serializing_if = "Option::is_none")]
    pub private_dns_names: Option<Vec<String>>,
    /// The account IDs of the owner of the public IPs associated with the private IPs.
    #[serde(
        rename = "PrivateIpsLinkPublicIpAccountIds",
        skip_serializing_if = "Option::is_none"
    )]
    pub private_ips_link_public_ip_account_ids: Option<Vec<String>>,
    /// The public IPs associated with the private IPs.
    #[serde(
        rename = "PrivateIpsLinkPublicIpPublicIps",
        skip_serializing_if = "Option::is_none"
    )]
    pub private_ips_link_public_ip_public_ips: Option<Vec<String>>,
    /// Whether the private IP is the primary IP associated with the NIC.
    #[serde(
        rename = "PrivateIpsPrimaryIp",
        skip_serializing_if = "Option::is_none"
    )]
    pub private_ips_primary_ip: Option<bool>,
    /// The private IPs of the NICs.
    #[serde(
        rename = "PrivateIpsPrivateIps",
        skip_serializing_if = "Option::is_none"
    )]
    pub private_ips_private_ips: Option<Vec<String>>,
    /// The IDs of the security groups associated with the NICs.
    #[serde(rename = "SecurityGroupIds", skip_serializing_if = "Option::is_none")]
    pub security_group_ids: Option<Vec<String>>,
    /// The names of the security groups associated with the NICs.
    #[serde(rename = "SecurityGroupNames", skip_serializing_if = "Option::is_none")]
    pub security_group_names: Option<Vec<String>>,
    /// The states of the NICs.
    #[serde(rename = "States", skip_serializing_if = "Option::is_none")]
    pub states: Option<Vec<String>>,
    /// The IDs of the Subnets for the NICs.
    #[serde(rename = "SubnetIds", skip_serializing_if = "Option::is_none")]
    pub subnet_ids: Option<Vec<String>>,
    /// The Subregions where the NICs are located.
    #[serde(rename = "SubregionNames", skip_serializing_if = "Option::is_none")]
    pub subregion_names: Option<Vec<String>>,
    /// The keys of the tags associated with the NICs.
    #[serde(rename = "TagKeys", skip_serializing_if = "Option::is_none")]
    pub tag_keys: Option<Vec<String>>,
    /// The values of the tags associated with the NICs.
    #[serde(rename = "TagValues", skip_serializing_if = "Option::is_none")]
    pub tag_values: Option<Vec<String>>,
    /// The key/value combination of the tags associated with the NICs, in the following format: &quot;Filters&quot;:{&quot;Tags&quot;:[&quot;TAGKEY=TAGVALUE&quot;]}.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
}

impl FiltersNic {
    /// One or more filters.
    pub fn new() -> FiltersNic {
        FiltersNic {
            descriptions: None,
            is_source_dest_check: None,
            link_nic_delete_on_vm_deletion: None,
            link_nic_device_numbers: None,
            link_nic_link_nic_ids: None,
            link_nic_states: None,
            link_nic_vm_account_ids: None,
            link_nic_vm_ids: None,
            link_public_ip_account_ids: None,
            link_public_ip_link_public_ip_ids: None,
            link_public_ip_public_ip_ids: None,
            link_public_ip_public_ips: None,
            mac_addresses: None,
            net_ids: None,
            nic_ids: None,
            private_dns_names: None,
            private_ips_link_public_ip_account_ids: None,
            private_ips_link_public_ip_public_ips: None,
            private_ips_primary_ip: None,
            private_ips_private_ips: None,
            security_group_ids: None,
            security_group_names: None,
            states: None,
            subnet_ids: None,
            subregion_names: None,
            tag_keys: None,
            tag_values: None,
            tags: None,
        }
    }
}
