/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersNatService : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersNatService {
    /// The IDs of the NAT services.
    #[serde(rename = "NatServiceIds", skip_serializing_if = "Option::is_none")]
    pub nat_service_ids: Option<Vec<String>>,
    /// The IDs of the Nets in which the NAT services are.
    #[serde(rename = "NetIds", skip_serializing_if = "Option::is_none")]
    pub net_ids: Option<Vec<String>>,
    /// The states of the NAT services (`pending` \\| `available` \\| `deleting` \\| `deleted`).
    #[serde(rename = "States", skip_serializing_if = "Option::is_none")]
    pub states: Option<Vec<String>>,
    /// The IDs of the Subnets in which the NAT services are.
    #[serde(rename = "SubnetIds", skip_serializing_if = "Option::is_none")]
    pub subnet_ids: Option<Vec<String>>,
    /// The keys of the tags associated with the NAT services.
    #[serde(rename = "TagKeys", skip_serializing_if = "Option::is_none")]
    pub tag_keys: Option<Vec<String>>,
    /// The values of the tags associated with the NAT services.
    #[serde(rename = "TagValues", skip_serializing_if = "Option::is_none")]
    pub tag_values: Option<Vec<String>>,
    /// The key/value combination of the tags associated with the NAT services, in the following format: &quot;Filters&quot;:{&quot;Tags&quot;:[&quot;TAGKEY=TAGVALUE&quot;]}.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
}

impl FiltersNatService {
    /// One or more filters.
    pub fn new() -> FiltersNatService {
        FiltersNatService {
            nat_service_ids: None,
            net_ids: None,
            states: None,
            subnet_ids: None,
            tag_keys: None,
            tag_values: None,
            tags: None,
        }
    }
}
