/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersFlexibleGpu : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersFlexibleGpu {
    /// Indicates whether the fGPU is deleted when terminating the VM.
    #[serde(rename = "DeleteOnVmDeletion", skip_serializing_if = "Option::is_none")]
    pub delete_on_vm_deletion: Option<bool>,
    /// One or more IDs of fGPUs.
    #[serde(rename = "FlexibleGpuIds", skip_serializing_if = "Option::is_none")]
    pub flexible_gpu_ids: Option<Vec<String>>,
    /// The processor generations that the fGPUs are compatible with.
    #[serde(rename = "Generations", skip_serializing_if = "Option::is_none")]
    pub generations: Option<Vec<String>>,
    /// One or more models of fGPUs. For more information, see [About Flexible GPUs](https://docs.outscale.com/en/userguide/About-Flexible-GPUs.html).
    #[serde(rename = "ModelNames", skip_serializing_if = "Option::is_none")]
    pub model_names: Option<Vec<String>>,
    /// The states of the fGPUs (`allocated` \\| `attaching` \\| `attached` \\| `detaching`).
    #[serde(rename = "States", skip_serializing_if = "Option::is_none")]
    pub states: Option<Vec<String>>,
    /// The Subregions where the fGPUs are located.
    #[serde(rename = "SubregionNames", skip_serializing_if = "Option::is_none")]
    pub subregion_names: Option<Vec<String>>,
    /// One or more IDs of VMs.
    #[serde(rename = "VmIds", skip_serializing_if = "Option::is_none")]
    pub vm_ids: Option<Vec<String>>,
}

impl FiltersFlexibleGpu {
    /// One or more filters.
    pub fn new() -> FiltersFlexibleGpu {
        FiltersFlexibleGpu {
            delete_on_vm_deletion: None,
            flexible_gpu_ids: None,
            generations: None,
            model_names: None,
            states: None,
            subregion_names: None,
            vm_ids: None,
        }
    }
}
