/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersApiLog : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersApiLog {
    /// The access keys used for the logged calls.
    #[serde(rename = "QueryAccessKeys", skip_serializing_if = "Option::is_none")]
    pub query_access_keys: Option<Vec<String>>,
    /// The names of the APIs of the logged calls (always `oapi` for the OUTSCALE API).
    #[serde(rename = "QueryApiNames", skip_serializing_if = "Option::is_none")]
    pub query_api_names: Option<Vec<String>>,
    /// The names of the logged calls.
    #[serde(rename = "QueryCallNames", skip_serializing_if = "Option::is_none")]
    pub query_call_names: Option<Vec<String>>,
    /// The date after which you want to retrieve logged calls, in ISO 8601 format (for example, `2020-06-14`). By default, this date is set to 48 hours before the `QueryDateBefore` parameter value.
    #[serde(rename = "QueryDateAfter", skip_serializing_if = "Option::is_none")]
    pub query_date_after: Option<String>,
    /// The date before which you want to retrieve logged calls, in ISO 8601 format (for example, `2020-06-30`). By default, this date is set to now, or 48 hours after the `QueryDateAfter` parameter value.
    #[serde(rename = "QueryDateBefore", skip_serializing_if = "Option::is_none")]
    pub query_date_before: Option<String>,
    /// The IPs used for the logged calls.
    #[serde(rename = "QueryIpAddresses", skip_serializing_if = "Option::is_none")]
    pub query_ip_addresses: Option<Vec<String>>,
    /// The user agents of the HTTP requests of the logged calls.
    #[serde(rename = "QueryUserAgents", skip_serializing_if = "Option::is_none")]
    pub query_user_agents: Option<Vec<String>>,
    /// The request IDs provided in the responses of the logged calls.
    #[serde(rename = "RequestIds", skip_serializing_if = "Option::is_none")]
    pub request_ids: Option<Vec<String>>,
    /// The HTTP status codes of the logged calls.
    #[serde(
        rename = "ResponseStatusCodes",
        skip_serializing_if = "Option::is_none"
    )]
    pub response_status_codes: Option<Vec<i32>>,
}

impl FiltersApiLog {
    /// One or more filters.
    pub fn new() -> FiltersApiLog {
        FiltersApiLog {
            query_access_keys: None,
            query_api_names: None,
            query_call_names: None,
            query_date_after: None,
            query_date_before: None,
            query_ip_addresses: None,
            query_user_agents: None,
            request_ids: None,
            response_status_codes: None,
        }
    }
}
