/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// FiltersAccessKeys : One or more filters.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FiltersAccessKeys {
    /// The IDs of the access keys.
    #[serde(rename = "AccessKeyIds", skip_serializing_if = "Option::is_none")]
    pub access_key_ids: Option<Vec<String>>,
    /// The states of the access keys (`ACTIVE` \\| `INACTIVE`).
    #[serde(rename = "States", skip_serializing_if = "Option::is_none")]
    pub states: Option<Vec<String>>,
}

impl FiltersAccessKeys {
    /// One or more filters.
    pub fn new() -> FiltersAccessKeys {
        FiltersAccessKeys {
            access_key_ids: None,
            states: None,
        }
    }
}
