/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// DirectLinkInterface : Information about the DirectLink interface.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DirectLinkInterface {
    /// The BGP (Border Gateway Protocol) ASN (Autonomous System Number) on the customer's side of the DirectLink interface.
    #[serde(rename = "BgpAsn")]
    pub bgp_asn: i32,
    /// The BGP authentication key.
    #[serde(rename = "BgpKey", skip_serializing_if = "Option::is_none")]
    pub bgp_key: Option<String>,
    /// The IP on the customer's side of the DirectLink interface.
    #[serde(rename = "ClientPrivateIp", skip_serializing_if = "Option::is_none")]
    pub client_private_ip: Option<String>,
    /// The name of the DirectLink interface.
    #[serde(rename = "DirectLinkInterfaceName")]
    pub direct_link_interface_name: String,
    /// The IP on the OUTSCALE side of the DirectLink interface.
    #[serde(rename = "OutscalePrivateIp", skip_serializing_if = "Option::is_none")]
    pub outscale_private_ip: Option<String>,
    /// The ID of the target virtual gateway.
    #[serde(rename = "VirtualGatewayId")]
    pub virtual_gateway_id: String,
    /// The VLAN number associated with the DirectLink interface.
    #[serde(rename = "Vlan")]
    pub vlan: i32,
}

impl DirectLinkInterface {
    /// Information about the DirectLink interface.
    pub fn new(
        bgp_asn: i32,
        direct_link_interface_name: String,
        virtual_gateway_id: String,
        vlan: i32,
    ) -> DirectLinkInterface {
        DirectLinkInterface {
            bgp_asn,
            bgp_key: None,
            client_private_ip: None,
            direct_link_interface_name,
            outscale_private_ip: None,
            virtual_gateway_id,
            vlan,
        }
    }
}
