/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// DhcpOptionsSet : Information about the DHCP options set.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct DhcpOptionsSet {
    /// If true, the DHCP options set is a default one. If false, it is not.
    #[serde(rename = "Default", skip_serializing_if = "Option::is_none")]
    pub default: Option<bool>,
    /// The ID of the DHCP options set.
    #[serde(rename = "DhcpOptionsSetId", skip_serializing_if = "Option::is_none")]
    pub dhcp_options_set_id: Option<String>,
    /// The domain name.
    #[serde(rename = "DomainName", skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    /// One or more IPs for the domain name servers.
    #[serde(rename = "DomainNameServers", skip_serializing_if = "Option::is_none")]
    pub domain_name_servers: Option<Vec<String>>,
    /// One or more IPs for the NTP servers.
    #[serde(rename = "NtpServers", skip_serializing_if = "Option::is_none")]
    pub ntp_servers: Option<Vec<String>>,
    /// One or more tags associated with the DHCP options set.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
}

impl DhcpOptionsSet {
    /// Information about the DHCP options set.
    pub fn new() -> DhcpOptionsSet {
        DhcpOptionsSet {
            default: None,
            dhcp_options_set_id: None,
            domain_name: None,
            domain_name_servers: None,
            ntp_servers: None,
            tags: None,
        }
    }
}
