/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateVpnConnectionRouteRequest {
    /// The network prefix of the route, in CIDR notation (for example, 10.12.0.0/16).
    #[serde(rename = "DestinationIpRange")]
    pub destination_ip_range: String,
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The ID of the target VPN connection of the static route.
    #[serde(rename = "VpnConnectionId")]
    pub vpn_connection_id: String,
}

impl CreateVpnConnectionRouteRequest {
    pub fn new(
        destination_ip_range: String,
        vpn_connection_id: String,
    ) -> CreateVpnConnectionRouteRequest {
        CreateVpnConnectionRouteRequest {
            destination_ip_range,
            dry_run: None,
            vpn_connection_id,
        }
    }
}
