/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateVpnConnectionRequest {
    /// The ID of the client gateway.
    #[serde(rename = "ClientGatewayId")]
    pub client_gateway_id: String,
    /// The type of VPN connection (only `ipsec.1` is supported).
    #[serde(rename = "ConnectionType")]
    pub connection_type: String,
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// If false, the VPN connection uses dynamic routing with Border Gateway Protocol (BGP). If true, routing is controlled using static routes. For more information about how to create and delete static routes, see [CreateVpnConnectionRoute](#createvpnconnectionroute) and [DeleteVpnConnectionRoute](#deletevpnconnectionroute).
    #[serde(rename = "StaticRoutesOnly", skip_serializing_if = "Option::is_none")]
    pub static_routes_only: Option<bool>,
    /// The ID of the virtual gateway.
    #[serde(rename = "VirtualGatewayId")]
    pub virtual_gateway_id: String,
}

impl CreateVpnConnectionRequest {
    pub fn new(
        client_gateway_id: String,
        connection_type: String,
        virtual_gateway_id: String,
    ) -> CreateVpnConnectionRequest {
        CreateVpnConnectionRequest {
            client_gateway_id,
            connection_type,
            dry_run: None,
            static_routes_only: None,
            virtual_gateway_id,
        }
    }
}
