/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateVmsRequest {
    /// One or more block device mappings.
    #[serde(
        rename = "BlockDeviceMappings",
        skip_serializing_if = "Option::is_none"
    )]
    pub block_device_mappings: Option<Vec<crate::models::BlockDeviceMappingVmCreation>>,
    /// By default or if true, the VM is started on creation. If false, the VM is stopped on creation.
    #[serde(rename = "BootOnCreation", skip_serializing_if = "Option::is_none")]
    pub boot_on_creation: Option<bool>,
    /// This parameter is not available. It is present in our API for the sake of historical compatibility with AWS.
    #[serde(rename = "BsuOptimized", skip_serializing_if = "Option::is_none")]
    pub bsu_optimized: Option<bool>,
    /// A unique identifier which enables you to manage the idempotency.
    #[serde(rename = "ClientToken", skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// If true, you cannot terminate the VM using Cockpit, the CLI or the API. If false, you can.
    #[serde(rename = "DeletionProtection", skip_serializing_if = "Option::is_none")]
    pub deletion_protection: Option<bool>,
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The ID of the OMI used to create the VM. You can find the list of OMIs by calling the [ReadImages](#readimages) method.
    #[serde(rename = "ImageId")]
    pub image_id: String,
    /// The name of the keypair.
    #[serde(rename = "KeypairName", skip_serializing_if = "Option::is_none")]
    pub keypair_name: Option<String>,
    /// The maximum number of VMs you want to create. If all the VMs cannot be created, the largest possible number of VMs above MinVmsCount is created.
    #[serde(rename = "MaxVmsCount", skip_serializing_if = "Option::is_none")]
    pub max_vms_count: Option<i32>,
    /// The minimum number of VMs you want to create. If this number of VMs cannot be created, no VMs are created.
    #[serde(rename = "MinVmsCount", skip_serializing_if = "Option::is_none")]
    pub min_vms_count: Option<i32>,
    /// One or more NICs. If you specify this parameter, you must not specify the `SubnetId` and `SubregionName` parameters. You also must define one NIC as the primary network interface of the VM with `0` as its device number.
    #[serde(rename = "Nics", skip_serializing_if = "Option::is_none")]
    pub nics: Option<Vec<crate::models::NicForVmCreation>>,
    /// The performance of the VM (`medium` \\| `high` \\|  `highest`).
    #[serde(rename = "Performance", skip_serializing_if = "Option::is_none")]
    pub performance: Option<Performance>,
    #[serde(rename = "Placement", skip_serializing_if = "Option::is_none")]
    pub placement: Option<Box<crate::models::Placement>>,
    /// One or more private IPs of the VM.
    #[serde(rename = "PrivateIps", skip_serializing_if = "Option::is_none")]
    pub private_ips: Option<Vec<String>>,
    /// One or more IDs of security group for the VMs.
    #[serde(rename = "SecurityGroupIds", skip_serializing_if = "Option::is_none")]
    pub security_group_ids: Option<Vec<String>>,
    /// One or more names of security groups for the VMs.
    #[serde(rename = "SecurityGroups", skip_serializing_if = "Option::is_none")]
    pub security_groups: Option<Vec<String>>,
    /// The ID of the Subnet in which you want to create the VM. If you specify this parameter, you must not specify the `Nics` parameter.
    #[serde(rename = "SubnetId", skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    /// Data or script used to add a specific configuration to the VM. It must be Base64-encoded and is limited to 500 kibibytes (KiB).
    #[serde(rename = "UserData", skip_serializing_if = "Option::is_none")]
    pub user_data: Option<String>,
    /// The VM behavior when you stop it. By default or if set to `stop`, the VM stops. If set to `restart`, the VM stops then automatically restarts. If set to `terminate`, the VM stops and is terminated.
    #[serde(
        rename = "VmInitiatedShutdownBehavior",
        skip_serializing_if = "Option::is_none"
    )]
    pub vm_initiated_shutdown_behavior: Option<String>,
    /// The type of VM (`t2.small` by default).<br /> For more information, see [Instance Types](https://docs.outscale.com/en/userguide/Instance-Types.html).
    #[serde(rename = "VmType", skip_serializing_if = "Option::is_none")]
    pub vm_type: Option<String>,
}

impl CreateVmsRequest {
    pub fn new(image_id: String) -> CreateVmsRequest {
        CreateVmsRequest {
            block_device_mappings: None,
            boot_on_creation: None,
            bsu_optimized: None,
            client_token: None,
            deletion_protection: None,
            dry_run: None,
            image_id,
            keypair_name: None,
            max_vms_count: None,
            min_vms_count: None,
            nics: None,
            performance: None,
            placement: None,
            private_ips: None,
            security_group_ids: None,
            security_groups: None,
            subnet_id: None,
            user_data: None,
            vm_initiated_shutdown_behavior: None,
            vm_type: None,
        }
    }
}

/// The performance of the VM (`medium` \\| `high` \\|  `highest`).
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Performance {
    #[serde(rename = "medium")]
    Medium,
    #[serde(rename = "high")]
    High,
    #[serde(rename = "highest")]
    Highest,
}

impl Default for Performance {
    fn default() -> Performance {
        Self::Medium
    }
}
