/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateSubnetRequest {
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The IP range in the Subnet, in CIDR notation (for example, 10.0.0.0/16).
    #[serde(rename = "IpRange")]
    pub ip_range: String,
    /// The ID of the Net for which you want to create a Subnet.
    #[serde(rename = "NetId")]
    pub net_id: String,
    /// The name of the Subregion in which you want to create the Subnet.
    #[serde(rename = "SubregionName", skip_serializing_if = "Option::is_none")]
    pub subregion_name: Option<String>,
}

impl CreateSubnetRequest {
    pub fn new(ip_range: String, net_id: String) -> CreateSubnetRequest {
        CreateSubnetRequest {
            dry_run: None,
            ip_range,
            net_id,
            subregion_name: None,
        }
    }
}
