/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateNetAccessPointRequest {
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The ID of the Net.
    #[serde(rename = "NetId")]
    pub net_id: String,
    /// One or more IDs of route tables to use for the connection.
    #[serde(rename = "RouteTableIds", skip_serializing_if = "Option::is_none")]
    pub route_table_ids: Option<Vec<String>>,
    /// The name of the service (in the format `com.outscale.region.service`).
    #[serde(rename = "ServiceName")]
    pub service_name: String,
}

impl CreateNetAccessPointRequest {
    pub fn new(net_id: String, service_name: String) -> CreateNetAccessPointRequest {
        CreateNetAccessPointRequest {
            dry_run: None,
            net_id,
            route_table_ids: None,
            service_name,
        }
    }
}
