/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateLoadBalancerPolicyRequest {
    /// The lifetime of the cookie, in seconds. If not specified, the default value of this parameter is 1, which means that the sticky session lasts for the duration of the browser session.
    #[serde(
        rename = "CookieExpirationPeriod",
        skip_serializing_if = "Option::is_none"
    )]
    pub cookie_expiration_period: Option<i32>,
    /// The name of the application cookie used for stickiness. This parameter is required if you create a stickiness policy based on an application-generated cookie.
    #[serde(rename = "CookieName", skip_serializing_if = "Option::is_none")]
    pub cookie_name: Option<String>,
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The name of the load balancer for which you want to create a policy.
    #[serde(rename = "LoadBalancerName")]
    pub load_balancer_name: String,
    /// The name of the policy. This name must be unique and consist of alphanumeric characters and dashes (-).
    #[serde(rename = "PolicyName")]
    pub policy_name: String,
    /// The type of stickiness policy you want to create: `app` or `load_balancer`.
    #[serde(rename = "PolicyType")]
    pub policy_type: String,
}

impl CreateLoadBalancerPolicyRequest {
    pub fn new(
        load_balancer_name: String,
        policy_name: String,
        policy_type: String,
    ) -> CreateLoadBalancerPolicyRequest {
        CreateLoadBalancerPolicyRequest {
            cookie_expiration_period: None,
            cookie_name: None,
            dry_run: None,
            load_balancer_name,
            policy_name,
            policy_type,
        }
    }
}
