/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateFlexibleGpuRequest {
    /// If true, the fGPU is deleted when the VM is terminated.
    #[serde(rename = "DeleteOnVmDeletion", skip_serializing_if = "Option::is_none")]
    pub delete_on_vm_deletion: Option<bool>,
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The processor generation that the fGPU must be compatible with. If not specified, the oldest possible processor generation is selected (as provided by [ReadFlexibleGpuCatalog](#readflexiblegpucatalog) for the specified model of fGPU).
    #[serde(rename = "Generation", skip_serializing_if = "Option::is_none")]
    pub generation: Option<String>,
    /// The model of fGPU you want to allocate. For more information, see [About Flexible GPUs](https://docs.outscale.com/en/userguide/About-Flexible-GPUs.html).
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// The Subregion in which you want to create the fGPU.
    #[serde(rename = "SubregionName")]
    pub subregion_name: String,
}

impl CreateFlexibleGpuRequest {
    pub fn new(model_name: String, subregion_name: String) -> CreateFlexibleGpuRequest {
        CreateFlexibleGpuRequest {
            delete_on_vm_deletion: None,
            dry_run: None,
            generation: None,
            model_name,
            subregion_name,
        }
    }
}
