/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateClientGatewayRequest {
    /// The Autonomous System Number (ASN) used by the Border Gateway Protocol (BGP) to find the path to your client gateway through the Internet. This number must be between 1 and 4294967295.
    #[serde(rename = "BgpAsn")]
    pub bgp_asn: i32,
    /// The communication protocol used to establish tunnel with your client gateway (only `ipsec.1` is supported).
    #[serde(rename = "ConnectionType")]
    pub connection_type: String,
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The public fixed IPv4 address of your client gateway.
    #[serde(rename = "PublicIp")]
    pub public_ip: String,
}

impl CreateClientGatewayRequest {
    pub fn new(
        bgp_asn: i32,
        connection_type: String,
        public_ip: String,
    ) -> CreateClientGatewayRequest {
        CreateClientGatewayRequest {
            bgp_asn,
            connection_type,
            dry_run: None,
            public_ip,
        }
    }
}
