/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// Ca : Information about the Client Certificate Authority (CA).

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Ca {
    /// The fingerprint of the CA.
    #[serde(rename = "CaFingerprint", skip_serializing_if = "Option::is_none")]
    pub ca_fingerprint: Option<String>,
    /// The ID of the CA.
    #[serde(rename = "CaId", skip_serializing_if = "Option::is_none")]
    pub ca_id: Option<String>,
    /// The description of the CA.
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
}

impl Ca {
    /// Information about the Client Certificate Authority (CA).
    pub fn new() -> Ca {
        Ca {
            ca_fingerprint: None,
            ca_id: None,
            description: None,
        }
    }
}
