/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// BackendVmHealth : Information about the health of a back-end VM.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct BackendVmHealth {
    /// The description of the state of the back-end VM.
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The state of the back-end VM (`InService` \\| `OutOfService` \\| `Unknown`).
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    /// Information about the cause of `OutOfService` VMs.<br /> Specifically, whether the cause is Elastic Load Balancing or the VM (`ELB` \\| `Instance` \\| `N/A`).
    #[serde(rename = "StateReason", skip_serializing_if = "Option::is_none")]
    pub state_reason: Option<String>,
    /// The ID of the back-end VM.
    #[serde(rename = "VmId", skip_serializing_if = "Option::is_none")]
    pub vm_id: Option<String>,
}

impl BackendVmHealth {
    /// Information about the health of a back-end VM.
    pub fn new() -> BackendVmHealth {
        BackendVmHealth {
            description: None,
            state: None,
            state_reason: None,
            vm_id: None,
        }
    }
}
