/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// Account : Information about the account.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Account {
    /// The ID of the account.
    #[serde(rename = "AccountId", skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// One or more additional email addresses for the account. These addresses are used for notifications only.
    #[serde(rename = "AdditionalEmails", skip_serializing_if = "Option::is_none")]
    pub additional_emails: Option<Vec<String>>,
    /// The city of the account owner.
    #[serde(rename = "City", skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    /// The name of the company for the account.
    #[serde(rename = "CompanyName", skip_serializing_if = "Option::is_none")]
    pub company_name: Option<String>,
    /// The country of the account owner.
    #[serde(rename = "Country", skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    /// The ID of the customer.
    #[serde(rename = "CustomerId", skip_serializing_if = "Option::is_none")]
    pub customer_id: Option<String>,
    /// The main email address for the account. This address is used for your credentials and for notifications.
    #[serde(rename = "Email", skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    /// The first name of the account owner.
    #[serde(rename = "FirstName", skip_serializing_if = "Option::is_none")]
    pub first_name: Option<String>,
    /// The job title of the account owner.
    #[serde(rename = "JobTitle", skip_serializing_if = "Option::is_none")]
    pub job_title: Option<String>,
    /// The last name of the account owner.
    #[serde(rename = "LastName", skip_serializing_if = "Option::is_none")]
    pub last_name: Option<String>,
    /// The mobile phone number of the account owner.
    #[serde(rename = "MobileNumber", skip_serializing_if = "Option::is_none")]
    pub mobile_number: Option<String>,
    /// The landline phone number of the account owner.
    #[serde(rename = "PhoneNumber", skip_serializing_if = "Option::is_none")]
    pub phone_number: Option<String>,
    /// The state/province of the account.
    #[serde(rename = "StateProvince", skip_serializing_if = "Option::is_none")]
    pub state_province: Option<String>,
    /// The value added tax (VAT) number for the account.
    #[serde(rename = "VatNumber", skip_serializing_if = "Option::is_none")]
    pub vat_number: Option<String>,
    /// The ZIP code of the city.
    #[serde(rename = "ZipCode", skip_serializing_if = "Option::is_none")]
    pub zip_code: Option<String>,
}

impl Account {
    /// Information about the account.
    pub fn new() -> Account {
        Account {
            account_id: None,
            additional_emails: None,
            city: None,
            company_name: None,
            country: None,
            customer_id: None,
            email: None,
            first_name: None,
            job_title: None,
            last_name: None,
            mobile_number: None,
            phone_number: None,
            state_province: None,
            vat_number: None,
            zip_code: None,
        }
    }
}
