/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// AccessLog : Information about access logs.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct AccessLog {
    /// If true, access logs are enabled for your load balancer. If false, they are not. If you set this to true in your request, the `OsuBucketName` parameter is required.
    #[serde(rename = "IsEnabled", skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
    /// The name of the OOS bucket for the access logs.
    #[serde(rename = "OsuBucketName", skip_serializing_if = "Option::is_none")]
    pub osu_bucket_name: Option<String>,
    /// The path to the folder of the access logs in your OOS bucket (by default, the `root` level of your bucket).
    #[serde(rename = "OsuBucketPrefix", skip_serializing_if = "Option::is_none")]
    pub osu_bucket_prefix: Option<String>,
    /// The time interval for the publication of access logs in the OOS bucket, in minutes. This value can be either 5 or 60 (by default, 60).
    #[serde(
        rename = "PublicationInterval",
        skip_serializing_if = "Option::is_none"
    )]
    pub publication_interval: Option<i32>,
}

impl AccessLog {
    /// Information about access logs.
    pub fn new() -> AccessLog {
        AccessLog {
            is_enabled: None,
            osu_bucket_name: None,
            osu_bucket_prefix: None,
            publication_interval: None,
        }
    }
}
