/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// AccessKeySecretKey : Information about the access key.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct AccessKeySecretKey {
    /// The ID of the access key.
    #[serde(rename = "AccessKeyId", skip_serializing_if = "Option::is_none")]
    pub access_key_id: Option<String>,
    /// The date and time (UTC) of creation of the access key.
    #[serde(rename = "CreationDate", skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    /// The date and time (UTC) at which the access key expires.
    #[serde(rename = "ExpirationDate", skip_serializing_if = "Option::is_none")]
    pub expiration_date: Option<String>,
    /// The date and time (UTC) of the last modification of the access key.
    #[serde(
        rename = "LastModificationDate",
        skip_serializing_if = "Option::is_none"
    )]
    pub last_modification_date: Option<String>,
    /// The access key that enables you to send requests.
    #[serde(rename = "SecretKey", skip_serializing_if = "Option::is_none")]
    pub secret_key: Option<String>,
    /// The state of the access key (`ACTIVE` if the key is valid for API calls, or `INACTIVE` if not).
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}

impl AccessKeySecretKey {
    /// Information about the access key.
    pub fn new() -> AccessKeySecretKey {
        AccessKeySecretKey {
            access_key_id: None,
            creation_date: None,
            expiration_date: None,
            last_modification_date: None,
            secret_key: None,
            state: None,
        }
    }
}
