# Rust API client for outscale_api

Welcome to the OUTSCALE API documentation.<br /><br />

The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />

Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />

You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.19
- Package version: 0.4.0
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `outscale_api` and add the following to `Cargo.toml` under `[dependencies]`:

```
outscale_api = { path = "./outscale_api" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.eu-west-2.outscale.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessKeyApi* | [**create_access_key**](docs/AccessKeyApi.md#create_access_key) | **POST** /CreateAccessKey | 
*AccessKeyApi* | [**delete_access_key**](docs/AccessKeyApi.md#delete_access_key) | **POST** /DeleteAccessKey | 
*AccessKeyApi* | [**read_access_keys**](docs/AccessKeyApi.md#read_access_keys) | **POST** /ReadAccessKeys | 
*AccessKeyApi* | [**read_secret_access_key**](docs/AccessKeyApi.md#read_secret_access_key) | **POST** /ReadSecretAccessKey | 
*AccessKeyApi* | [**update_access_key**](docs/AccessKeyApi.md#update_access_key) | **POST** /UpdateAccessKey | 
*AccountApi* | [**check_authentication**](docs/AccountApi.md#check_authentication) | **POST** /CheckAuthentication | 
*AccountApi* | [**create_account**](docs/AccountApi.md#create_account) | **POST** /CreateAccount | 
*AccountApi* | [**read_accounts**](docs/AccountApi.md#read_accounts) | **POST** /ReadAccounts | 
*AccountApi* | [**read_consumption_account**](docs/AccountApi.md#read_consumption_account) | **POST** /ReadConsumptionAccount | 
*AccountApi* | [**reset_account_password**](docs/AccountApi.md#reset_account_password) | **POST** /ResetAccountPassword | 
*AccountApi* | [**send_reset_password_email**](docs/AccountApi.md#send_reset_password_email) | **POST** /SendResetPasswordEmail | 
*AccountApi* | [**update_account**](docs/AccountApi.md#update_account) | **POST** /UpdateAccount | 
*ApiAccessPolicyApi* | [**read_api_access_policy**](docs/ApiAccessPolicyApi.md#read_api_access_policy) | **POST** /ReadApiAccessPolicy | 
*ApiAccessPolicyApi* | [**update_api_access_policy**](docs/ApiAccessPolicyApi.md#update_api_access_policy) | **POST** /UpdateApiAccessPolicy | 
*ApiAccessRuleApi* | [**create_api_access_rule**](docs/ApiAccessRuleApi.md#create_api_access_rule) | **POST** /CreateApiAccessRule | 
*ApiAccessRuleApi* | [**delete_api_access_rule**](docs/ApiAccessRuleApi.md#delete_api_access_rule) | **POST** /DeleteApiAccessRule | 
*ApiAccessRuleApi* | [**read_api_access_rules**](docs/ApiAccessRuleApi.md#read_api_access_rules) | **POST** /ReadApiAccessRules | 
*ApiAccessRuleApi* | [**update_api_access_rule**](docs/ApiAccessRuleApi.md#update_api_access_rule) | **POST** /UpdateApiAccessRule | 
*ApiLogApi* | [**read_api_logs**](docs/ApiLogApi.md#read_api_logs) | **POST** /ReadApiLogs | 
*CaApi* | [**create_ca**](docs/CaApi.md#create_ca) | **POST** /CreateCa | 
*CaApi* | [**delete_ca**](docs/CaApi.md#delete_ca) | **POST** /DeleteCa | 
*CaApi* | [**read_cas**](docs/CaApi.md#read_cas) | **POST** /ReadCas | 
*CaApi* | [**update_ca**](docs/CaApi.md#update_ca) | **POST** /UpdateCa | 
*CatalogApi* | [**read_catalog**](docs/CatalogApi.md#read_catalog) | **POST** /ReadCatalog | 
*ClientGatewayApi* | [**create_client_gateway**](docs/ClientGatewayApi.md#create_client_gateway) | **POST** /CreateClientGateway | 
*ClientGatewayApi* | [**delete_client_gateway**](docs/ClientGatewayApi.md#delete_client_gateway) | **POST** /DeleteClientGateway | 
*ClientGatewayApi* | [**read_client_gateways**](docs/ClientGatewayApi.md#read_client_gateways) | **POST** /ReadClientGateways | 
*DhcpOptionApi* | [**create_dhcp_options**](docs/DhcpOptionApi.md#create_dhcp_options) | **POST** /CreateDhcpOptions | 
*DhcpOptionApi* | [**delete_dhcp_options**](docs/DhcpOptionApi.md#delete_dhcp_options) | **POST** /DeleteDhcpOptions | 
*DhcpOptionApi* | [**read_dhcp_options**](docs/DhcpOptionApi.md#read_dhcp_options) | **POST** /ReadDhcpOptions | 
*DirectLinkApi* | [**create_direct_link**](docs/DirectLinkApi.md#create_direct_link) | **POST** /CreateDirectLink | 
*DirectLinkApi* | [**delete_direct_link**](docs/DirectLinkApi.md#delete_direct_link) | **POST** /DeleteDirectLink | 
*DirectLinkApi* | [**read_direct_links**](docs/DirectLinkApi.md#read_direct_links) | **POST** /ReadDirectLinks | 
*DirectLinkInterfaceApi* | [**create_direct_link_interface**](docs/DirectLinkInterfaceApi.md#create_direct_link_interface) | **POST** /CreateDirectLinkInterface | 
*DirectLinkInterfaceApi* | [**delete_direct_link_interface**](docs/DirectLinkInterfaceApi.md#delete_direct_link_interface) | **POST** /DeleteDirectLinkInterface | 
*DirectLinkInterfaceApi* | [**read_direct_link_interfaces**](docs/DirectLinkInterfaceApi.md#read_direct_link_interfaces) | **POST** /ReadDirectLinkInterfaces | 
*FlexibleGpuApi* | [**create_flexible_gpu**](docs/FlexibleGpuApi.md#create_flexible_gpu) | **POST** /CreateFlexibleGpu | 
*FlexibleGpuApi* | [**delete_flexible_gpu**](docs/FlexibleGpuApi.md#delete_flexible_gpu) | **POST** /DeleteFlexibleGpu | 
*FlexibleGpuApi* | [**link_flexible_gpu**](docs/FlexibleGpuApi.md#link_flexible_gpu) | **POST** /LinkFlexibleGpu | 
*FlexibleGpuApi* | [**read_flexible_gpu_catalog**](docs/FlexibleGpuApi.md#read_flexible_gpu_catalog) | **POST** /ReadFlexibleGpuCatalog | 
*FlexibleGpuApi* | [**read_flexible_gpus**](docs/FlexibleGpuApi.md#read_flexible_gpus) | **POST** /ReadFlexibleGpus | 
*FlexibleGpuApi* | [**unlink_flexible_gpu**](docs/FlexibleGpuApi.md#unlink_flexible_gpu) | **POST** /UnlinkFlexibleGpu | 
*FlexibleGpuApi* | [**update_flexible_gpu**](docs/FlexibleGpuApi.md#update_flexible_gpu) | **POST** /UpdateFlexibleGpu | 
*ImageApi* | [**create_image**](docs/ImageApi.md#create_image) | **POST** /CreateImage | 
*ImageApi* | [**create_image_export_task**](docs/ImageApi.md#create_image_export_task) | **POST** /CreateImageExportTask | 
*ImageApi* | [**delete_image**](docs/ImageApi.md#delete_image) | **POST** /DeleteImage | 
*ImageApi* | [**read_image_export_tasks**](docs/ImageApi.md#read_image_export_tasks) | **POST** /ReadImageExportTasks | 
*ImageApi* | [**read_images**](docs/ImageApi.md#read_images) | **POST** /ReadImages | 
*ImageApi* | [**update_image**](docs/ImageApi.md#update_image) | **POST** /UpdateImage | 
*InternetServiceApi* | [**create_internet_service**](docs/InternetServiceApi.md#create_internet_service) | **POST** /CreateInternetService | 
*InternetServiceApi* | [**delete_internet_service**](docs/InternetServiceApi.md#delete_internet_service) | **POST** /DeleteInternetService | 
*InternetServiceApi* | [**link_internet_service**](docs/InternetServiceApi.md#link_internet_service) | **POST** /LinkInternetService | 
*InternetServiceApi* | [**read_internet_services**](docs/InternetServiceApi.md#read_internet_services) | **POST** /ReadInternetServices | 
*InternetServiceApi* | [**unlink_internet_service**](docs/InternetServiceApi.md#unlink_internet_service) | **POST** /UnlinkInternetService | 
*KeypairApi* | [**create_keypair**](docs/KeypairApi.md#create_keypair) | **POST** /CreateKeypair | 
*KeypairApi* | [**delete_keypair**](docs/KeypairApi.md#delete_keypair) | **POST** /DeleteKeypair | 
*KeypairApi* | [**read_keypairs**](docs/KeypairApi.md#read_keypairs) | **POST** /ReadKeypairs | 
*ListenerApi* | [**create_listener_rule**](docs/ListenerApi.md#create_listener_rule) | **POST** /CreateListenerRule | 
*ListenerApi* | [**create_load_balancer_listeners**](docs/ListenerApi.md#create_load_balancer_listeners) | **POST** /CreateLoadBalancerListeners | 
*ListenerApi* | [**delete_listener_rule**](docs/ListenerApi.md#delete_listener_rule) | **POST** /DeleteListenerRule | 
*ListenerApi* | [**delete_load_balancer_listeners**](docs/ListenerApi.md#delete_load_balancer_listeners) | **POST** /DeleteLoadBalancerListeners | 
*ListenerApi* | [**read_listener_rules**](docs/ListenerApi.md#read_listener_rules) | **POST** /ReadListenerRules | 
*ListenerApi* | [**update_listener_rule**](docs/ListenerApi.md#update_listener_rule) | **POST** /UpdateListenerRule | 
*LoadBalancerApi* | [**create_load_balancer**](docs/LoadBalancerApi.md#create_load_balancer) | **POST** /CreateLoadBalancer | 
*LoadBalancerApi* | [**create_load_balancer_tags**](docs/LoadBalancerApi.md#create_load_balancer_tags) | **POST** /CreateLoadBalancerTags | 
*LoadBalancerApi* | [**delete_load_balancer**](docs/LoadBalancerApi.md#delete_load_balancer) | **POST** /DeleteLoadBalancer | 
*LoadBalancerApi* | [**delete_load_balancer_tags**](docs/LoadBalancerApi.md#delete_load_balancer_tags) | **POST** /DeleteLoadBalancerTags | 
*LoadBalancerApi* | [**deregister_vms_in_load_balancer**](docs/LoadBalancerApi.md#deregister_vms_in_load_balancer) | **POST** /DeregisterVmsInLoadBalancer | 
*LoadBalancerApi* | [**link_load_balancer_backend_machines**](docs/LoadBalancerApi.md#link_load_balancer_backend_machines) | **POST** /LinkLoadBalancerBackendMachines | 
*LoadBalancerApi* | [**read_load_balancer_tags**](docs/LoadBalancerApi.md#read_load_balancer_tags) | **POST** /ReadLoadBalancerTags | 
*LoadBalancerApi* | [**read_load_balancers**](docs/LoadBalancerApi.md#read_load_balancers) | **POST** /ReadLoadBalancers | 
*LoadBalancerApi* | [**read_vms_health**](docs/LoadBalancerApi.md#read_vms_health) | **POST** /ReadVmsHealth | 
*LoadBalancerApi* | [**register_vms_in_load_balancer**](docs/LoadBalancerApi.md#register_vms_in_load_balancer) | **POST** /RegisterVmsInLoadBalancer | 
*LoadBalancerApi* | [**unlink_load_balancer_backend_machines**](docs/LoadBalancerApi.md#unlink_load_balancer_backend_machines) | **POST** /UnlinkLoadBalancerBackendMachines | 
*LoadBalancerApi* | [**update_load_balancer**](docs/LoadBalancerApi.md#update_load_balancer) | **POST** /UpdateLoadBalancer | 
*LoadBalancerPolicyApi* | [**create_load_balancer_policy**](docs/LoadBalancerPolicyApi.md#create_load_balancer_policy) | **POST** /CreateLoadBalancerPolicy | 
*LoadBalancerPolicyApi* | [**delete_load_balancer_policy**](docs/LoadBalancerPolicyApi.md#delete_load_balancer_policy) | **POST** /DeleteLoadBalancerPolicy | 
*LocationApi* | [**read_locations**](docs/LocationApi.md#read_locations) | **POST** /ReadLocations | 
*NatServiceApi* | [**create_nat_service**](docs/NatServiceApi.md#create_nat_service) | **POST** /CreateNatService | 
*NatServiceApi* | [**delete_nat_service**](docs/NatServiceApi.md#delete_nat_service) | **POST** /DeleteNatService | 
*NatServiceApi* | [**read_nat_services**](docs/NatServiceApi.md#read_nat_services) | **POST** /ReadNatServices | 
*NetApi* | [**create_net**](docs/NetApi.md#create_net) | **POST** /CreateNet | 
*NetApi* | [**delete_net**](docs/NetApi.md#delete_net) | **POST** /DeleteNet | 
*NetApi* | [**read_nets**](docs/NetApi.md#read_nets) | **POST** /ReadNets | 
*NetApi* | [**update_net**](docs/NetApi.md#update_net) | **POST** /UpdateNet | 
*NetAccessPointApi* | [**create_net_access_point**](docs/NetAccessPointApi.md#create_net_access_point) | **POST** /CreateNetAccessPoint | 
*NetAccessPointApi* | [**delete_net_access_point**](docs/NetAccessPointApi.md#delete_net_access_point) | **POST** /DeleteNetAccessPoint | 
*NetAccessPointApi* | [**read_net_access_point_services**](docs/NetAccessPointApi.md#read_net_access_point_services) | **POST** /ReadNetAccessPointServices | 
*NetAccessPointApi* | [**read_net_access_points**](docs/NetAccessPointApi.md#read_net_access_points) | **POST** /ReadNetAccessPoints | 
*NetAccessPointApi* | [**update_net_access_point**](docs/NetAccessPointApi.md#update_net_access_point) | **POST** /UpdateNetAccessPoint | 
*NetPeeringApi* | [**accept_net_peering**](docs/NetPeeringApi.md#accept_net_peering) | **POST** /AcceptNetPeering | 
*NetPeeringApi* | [**create_net_peering**](docs/NetPeeringApi.md#create_net_peering) | **POST** /CreateNetPeering | 
*NetPeeringApi* | [**delete_net_peering**](docs/NetPeeringApi.md#delete_net_peering) | **POST** /DeleteNetPeering | 
*NetPeeringApi* | [**read_net_peerings**](docs/NetPeeringApi.md#read_net_peerings) | **POST** /ReadNetPeerings | 
*NetPeeringApi* | [**reject_net_peering**](docs/NetPeeringApi.md#reject_net_peering) | **POST** /RejectNetPeering | 
*NicApi* | [**create_nic**](docs/NicApi.md#create_nic) | **POST** /CreateNic | 
*NicApi* | [**delete_nic**](docs/NicApi.md#delete_nic) | **POST** /DeleteNic | 
*NicApi* | [**link_nic**](docs/NicApi.md#link_nic) | **POST** /LinkNic | 
*NicApi* | [**link_private_ips**](docs/NicApi.md#link_private_ips) | **POST** /LinkPrivateIps | 
*NicApi* | [**read_nics**](docs/NicApi.md#read_nics) | **POST** /ReadNics | 
*NicApi* | [**unlink_nic**](docs/NicApi.md#unlink_nic) | **POST** /UnlinkNic | 
*NicApi* | [**unlink_private_ips**](docs/NicApi.md#unlink_private_ips) | **POST** /UnlinkPrivateIps | 
*NicApi* | [**update_nic**](docs/NicApi.md#update_nic) | **POST** /UpdateNic | 
*ProductTypeApi* | [**read_product_types**](docs/ProductTypeApi.md#read_product_types) | **POST** /ReadProductTypes | 
*PublicCatalogApi* | [**read_public_catalog**](docs/PublicCatalogApi.md#read_public_catalog) | **POST** /ReadPublicCatalog | 
*PublicIpApi* | [**create_public_ip**](docs/PublicIpApi.md#create_public_ip) | **POST** /CreatePublicIp | 
*PublicIpApi* | [**delete_public_ip**](docs/PublicIpApi.md#delete_public_ip) | **POST** /DeletePublicIp | 
*PublicIpApi* | [**link_public_ip**](docs/PublicIpApi.md#link_public_ip) | **POST** /LinkPublicIp | 
*PublicIpApi* | [**read_public_ip_ranges**](docs/PublicIpApi.md#read_public_ip_ranges) | **POST** /ReadPublicIpRanges | 
*PublicIpApi* | [**read_public_ips**](docs/PublicIpApi.md#read_public_ips) | **POST** /ReadPublicIps | 
*PublicIpApi* | [**unlink_public_ip**](docs/PublicIpApi.md#unlink_public_ip) | **POST** /UnlinkPublicIp | 
*QuotaApi* | [**read_quotas**](docs/QuotaApi.md#read_quotas) | **POST** /ReadQuotas | 
*RegionApi* | [**read_regions**](docs/RegionApi.md#read_regions) | **POST** /ReadRegions | 
*RouteApi* | [**create_route**](docs/RouteApi.md#create_route) | **POST** /CreateRoute | 
*RouteApi* | [**delete_route**](docs/RouteApi.md#delete_route) | **POST** /DeleteRoute | 
*RouteApi* | [**update_route**](docs/RouteApi.md#update_route) | **POST** /UpdateRoute | 
*RouteTableApi* | [**create_route_table**](docs/RouteTableApi.md#create_route_table) | **POST** /CreateRouteTable | 
*RouteTableApi* | [**delete_route_table**](docs/RouteTableApi.md#delete_route_table) | **POST** /DeleteRouteTable | 
*RouteTableApi* | [**link_route_table**](docs/RouteTableApi.md#link_route_table) | **POST** /LinkRouteTable | 
*RouteTableApi* | [**read_route_tables**](docs/RouteTableApi.md#read_route_tables) | **POST** /ReadRouteTables | 
*RouteTableApi* | [**unlink_route_table**](docs/RouteTableApi.md#unlink_route_table) | **POST** /UnlinkRouteTable | 
*SecurityGroupApi* | [**create_security_group**](docs/SecurityGroupApi.md#create_security_group) | **POST** /CreateSecurityGroup | 
*SecurityGroupApi* | [**delete_security_group**](docs/SecurityGroupApi.md#delete_security_group) | **POST** /DeleteSecurityGroup | 
*SecurityGroupApi* | [**read_security_groups**](docs/SecurityGroupApi.md#read_security_groups) | **POST** /ReadSecurityGroups | 
*SecurityGroupRuleApi* | [**create_security_group_rule**](docs/SecurityGroupRuleApi.md#create_security_group_rule) | **POST** /CreateSecurityGroupRule | 
*SecurityGroupRuleApi* | [**delete_security_group_rule**](docs/SecurityGroupRuleApi.md#delete_security_group_rule) | **POST** /DeleteSecurityGroupRule | 
*ServerCertificateApi* | [**create_server_certificate**](docs/ServerCertificateApi.md#create_server_certificate) | **POST** /CreateServerCertificate | 
*ServerCertificateApi* | [**delete_server_certificate**](docs/ServerCertificateApi.md#delete_server_certificate) | **POST** /DeleteServerCertificate | 
*ServerCertificateApi* | [**read_server_certificates**](docs/ServerCertificateApi.md#read_server_certificates) | **POST** /ReadServerCertificates | 
*ServerCertificateApi* | [**update_server_certificate**](docs/ServerCertificateApi.md#update_server_certificate) | **POST** /UpdateServerCertificate | 
*SnapshotApi* | [**create_snapshot**](docs/SnapshotApi.md#create_snapshot) | **POST** /CreateSnapshot | 
*SnapshotApi* | [**create_snapshot_export_task**](docs/SnapshotApi.md#create_snapshot_export_task) | **POST** /CreateSnapshotExportTask | 
*SnapshotApi* | [**delete_snapshot**](docs/SnapshotApi.md#delete_snapshot) | **POST** /DeleteSnapshot | 
*SnapshotApi* | [**read_snapshot_export_tasks**](docs/SnapshotApi.md#read_snapshot_export_tasks) | **POST** /ReadSnapshotExportTasks | 
*SnapshotApi* | [**read_snapshots**](docs/SnapshotApi.md#read_snapshots) | **POST** /ReadSnapshots | 
*SnapshotApi* | [**update_snapshot**](docs/SnapshotApi.md#update_snapshot) | **POST** /UpdateSnapshot | 
*SubnetApi* | [**create_subnet**](docs/SubnetApi.md#create_subnet) | **POST** /CreateSubnet | 
*SubnetApi* | [**delete_subnet**](docs/SubnetApi.md#delete_subnet) | **POST** /DeleteSubnet | 
*SubnetApi* | [**read_subnets**](docs/SubnetApi.md#read_subnets) | **POST** /ReadSubnets | 
*SubnetApi* | [**update_subnet**](docs/SubnetApi.md#update_subnet) | **POST** /UpdateSubnet | 
*SubregionApi* | [**read_subregions**](docs/SubregionApi.md#read_subregions) | **POST** /ReadSubregions | 
*TagApi* | [**create_tags**](docs/TagApi.md#create_tags) | **POST** /CreateTags | 
*TagApi* | [**delete_tags**](docs/TagApi.md#delete_tags) | **POST** /DeleteTags | 
*TagApi* | [**read_tags**](docs/TagApi.md#read_tags) | **POST** /ReadTags | 
*TaskApi* | [**delete_export_task**](docs/TaskApi.md#delete_export_task) | **POST** /DeleteExportTask | 
*VirtualGatewayApi* | [**create_virtual_gateway**](docs/VirtualGatewayApi.md#create_virtual_gateway) | **POST** /CreateVirtualGateway | 
*VirtualGatewayApi* | [**delete_virtual_gateway**](docs/VirtualGatewayApi.md#delete_virtual_gateway) | **POST** /DeleteVirtualGateway | 
*VirtualGatewayApi* | [**link_virtual_gateway**](docs/VirtualGatewayApi.md#link_virtual_gateway) | **POST** /LinkVirtualGateway | 
*VirtualGatewayApi* | [**read_virtual_gateways**](docs/VirtualGatewayApi.md#read_virtual_gateways) | **POST** /ReadVirtualGateways | 
*VirtualGatewayApi* | [**unlink_virtual_gateway**](docs/VirtualGatewayApi.md#unlink_virtual_gateway) | **POST** /UnlinkVirtualGateway | 
*VirtualGatewayApi* | [**update_route_propagation**](docs/VirtualGatewayApi.md#update_route_propagation) | **POST** /UpdateRoutePropagation | 
*VmApi* | [**create_vms**](docs/VmApi.md#create_vms) | **POST** /CreateVms | 
*VmApi* | [**delete_vms**](docs/VmApi.md#delete_vms) | **POST** /DeleteVms | 
*VmApi* | [**read_admin_password**](docs/VmApi.md#read_admin_password) | **POST** /ReadAdminPassword | 
*VmApi* | [**read_console_output**](docs/VmApi.md#read_console_output) | **POST** /ReadConsoleOutput | 
*VmApi* | [**read_vm_types**](docs/VmApi.md#read_vm_types) | **POST** /ReadVmTypes | 
*VmApi* | [**read_vms**](docs/VmApi.md#read_vms) | **POST** /ReadVms | 
*VmApi* | [**read_vms_state**](docs/VmApi.md#read_vms_state) | **POST** /ReadVmsState | 
*VmApi* | [**reboot_vms**](docs/VmApi.md#reboot_vms) | **POST** /RebootVms | 
*VmApi* | [**start_vms**](docs/VmApi.md#start_vms) | **POST** /StartVms | 
*VmApi* | [**stop_vms**](docs/VmApi.md#stop_vms) | **POST** /StopVms | 
*VmApi* | [**update_vm**](docs/VmApi.md#update_vm) | **POST** /UpdateVm | 
*VolumeApi* | [**create_volume**](docs/VolumeApi.md#create_volume) | **POST** /CreateVolume | 
*VolumeApi* | [**delete_volume**](docs/VolumeApi.md#delete_volume) | **POST** /DeleteVolume | 
*VolumeApi* | [**link_volume**](docs/VolumeApi.md#link_volume) | **POST** /LinkVolume | 
*VolumeApi* | [**read_volumes**](docs/VolumeApi.md#read_volumes) | **POST** /ReadVolumes | 
*VolumeApi* | [**unlink_volume**](docs/VolumeApi.md#unlink_volume) | **POST** /UnlinkVolume | 
*VolumeApi* | [**update_volume**](docs/VolumeApi.md#update_volume) | **POST** /UpdateVolume | 
*VpnConnectionApi* | [**create_vpn_connection**](docs/VpnConnectionApi.md#create_vpn_connection) | **POST** /CreateVpnConnection | 
*VpnConnectionApi* | [**create_vpn_connection_route**](docs/VpnConnectionApi.md#create_vpn_connection_route) | **POST** /CreateVpnConnectionRoute | 
*VpnConnectionApi* | [**delete_vpn_connection**](docs/VpnConnectionApi.md#delete_vpn_connection) | **POST** /DeleteVpnConnection | 
*VpnConnectionApi* | [**delete_vpn_connection_route**](docs/VpnConnectionApi.md#delete_vpn_connection_route) | **POST** /DeleteVpnConnectionRoute | 
*VpnConnectionApi* | [**read_vpn_connections**](docs/VpnConnectionApi.md#read_vpn_connections) | **POST** /ReadVpnConnections | 
*VpnConnectionApi* | [**update_vpn_connection**](docs/VpnConnectionApi.md#update_vpn_connection) | **POST** /UpdateVpnConnection | 


## Documentation For Models

 - [AcceptNetPeeringRequest](docs/AcceptNetPeeringRequest.md)
 - [AcceptNetPeeringResponse](docs/AcceptNetPeeringResponse.md)
 - [AccepterNet](docs/AccepterNet.md)
 - [AccessKey](docs/AccessKey.md)
 - [AccessKeySecretKey](docs/AccessKeySecretKey.md)
 - [AccessLog](docs/AccessLog.md)
 - [Account](docs/Account.md)
 - [ApiAccessPolicy](docs/ApiAccessPolicy.md)
 - [ApiAccessRule](docs/ApiAccessRule.md)
 - [ApplicationStickyCookiePolicy](docs/ApplicationStickyCookiePolicy.md)
 - [BackendVmHealth](docs/BackendVmHealth.md)
 - [BlockDeviceMappingCreated](docs/BlockDeviceMappingCreated.md)
 - [BlockDeviceMappingImage](docs/BlockDeviceMappingImage.md)
 - [BlockDeviceMappingVmCreation](docs/BlockDeviceMappingVmCreation.md)
 - [BlockDeviceMappingVmUpdate](docs/BlockDeviceMappingVmUpdate.md)
 - [BsuCreated](docs/BsuCreated.md)
 - [BsuToCreate](docs/BsuToCreate.md)
 - [BsuToUpdateVm](docs/BsuToUpdateVm.md)
 - [Ca](docs/Ca.md)
 - [Catalog](docs/Catalog.md)
 - [CatalogEntry](docs/CatalogEntry.md)
 - [CheckAuthenticationRequest](docs/CheckAuthenticationRequest.md)
 - [CheckAuthenticationResponse](docs/CheckAuthenticationResponse.md)
 - [ClientGateway](docs/ClientGateway.md)
 - [ConsumptionEntry](docs/ConsumptionEntry.md)
 - [CreateAccessKeyRequest](docs/CreateAccessKeyRequest.md)
 - [CreateAccessKeyResponse](docs/CreateAccessKeyResponse.md)
 - [CreateAccountRequest](docs/CreateAccountRequest.md)
 - [CreateAccountResponse](docs/CreateAccountResponse.md)
 - [CreateApiAccessRuleRequest](docs/CreateApiAccessRuleRequest.md)
 - [CreateApiAccessRuleResponse](docs/CreateApiAccessRuleResponse.md)
 - [CreateCaRequest](docs/CreateCaRequest.md)
 - [CreateCaResponse](docs/CreateCaResponse.md)
 - [CreateClientGatewayRequest](docs/CreateClientGatewayRequest.md)
 - [CreateClientGatewayResponse](docs/CreateClientGatewayResponse.md)
 - [CreateDhcpOptionsRequest](docs/CreateDhcpOptionsRequest.md)
 - [CreateDhcpOptionsResponse](docs/CreateDhcpOptionsResponse.md)
 - [CreateDirectLinkInterfaceRequest](docs/CreateDirectLinkInterfaceRequest.md)
 - [CreateDirectLinkInterfaceResponse](docs/CreateDirectLinkInterfaceResponse.md)
 - [CreateDirectLinkRequest](docs/CreateDirectLinkRequest.md)
 - [CreateDirectLinkResponse](docs/CreateDirectLinkResponse.md)
 - [CreateFlexibleGpuRequest](docs/CreateFlexibleGpuRequest.md)
 - [CreateFlexibleGpuResponse](docs/CreateFlexibleGpuResponse.md)
 - [CreateImageExportTaskRequest](docs/CreateImageExportTaskRequest.md)
 - [CreateImageExportTaskResponse](docs/CreateImageExportTaskResponse.md)
 - [CreateImageRequest](docs/CreateImageRequest.md)
 - [CreateImageResponse](docs/CreateImageResponse.md)
 - [CreateInternetServiceRequest](docs/CreateInternetServiceRequest.md)
 - [CreateInternetServiceResponse](docs/CreateInternetServiceResponse.md)
 - [CreateKeypairRequest](docs/CreateKeypairRequest.md)
 - [CreateKeypairResponse](docs/CreateKeypairResponse.md)
 - [CreateListenerRuleRequest](docs/CreateListenerRuleRequest.md)
 - [CreateListenerRuleResponse](docs/CreateListenerRuleResponse.md)
 - [CreateLoadBalancerListenersRequest](docs/CreateLoadBalancerListenersRequest.md)
 - [CreateLoadBalancerListenersResponse](docs/CreateLoadBalancerListenersResponse.md)
 - [CreateLoadBalancerPolicyRequest](docs/CreateLoadBalancerPolicyRequest.md)
 - [CreateLoadBalancerPolicyResponse](docs/CreateLoadBalancerPolicyResponse.md)
 - [CreateLoadBalancerRequest](docs/CreateLoadBalancerRequest.md)
 - [CreateLoadBalancerResponse](docs/CreateLoadBalancerResponse.md)
 - [CreateLoadBalancerTagsRequest](docs/CreateLoadBalancerTagsRequest.md)
 - [CreateLoadBalancerTagsResponse](docs/CreateLoadBalancerTagsResponse.md)
 - [CreateNatServiceRequest](docs/CreateNatServiceRequest.md)
 - [CreateNatServiceResponse](docs/CreateNatServiceResponse.md)
 - [CreateNetAccessPointRequest](docs/CreateNetAccessPointRequest.md)
 - [CreateNetAccessPointResponse](docs/CreateNetAccessPointResponse.md)
 - [CreateNetPeeringRequest](docs/CreateNetPeeringRequest.md)
 - [CreateNetPeeringResponse](docs/CreateNetPeeringResponse.md)
 - [CreateNetRequest](docs/CreateNetRequest.md)
 - [CreateNetResponse](docs/CreateNetResponse.md)
 - [CreateNicRequest](docs/CreateNicRequest.md)
 - [CreateNicResponse](docs/CreateNicResponse.md)
 - [CreatePublicIpRequest](docs/CreatePublicIpRequest.md)
 - [CreatePublicIpResponse](docs/CreatePublicIpResponse.md)
 - [CreateRouteRequest](docs/CreateRouteRequest.md)
 - [CreateRouteResponse](docs/CreateRouteResponse.md)
 - [CreateRouteTableRequest](docs/CreateRouteTableRequest.md)
 - [CreateRouteTableResponse](docs/CreateRouteTableResponse.md)
 - [CreateSecurityGroupRequest](docs/CreateSecurityGroupRequest.md)
 - [CreateSecurityGroupResponse](docs/CreateSecurityGroupResponse.md)
 - [CreateSecurityGroupRuleRequest](docs/CreateSecurityGroupRuleRequest.md)
 - [CreateSecurityGroupRuleResponse](docs/CreateSecurityGroupRuleResponse.md)
 - [CreateServerCertificateRequest](docs/CreateServerCertificateRequest.md)
 - [CreateServerCertificateResponse](docs/CreateServerCertificateResponse.md)
 - [CreateSnapshotExportTaskRequest](docs/CreateSnapshotExportTaskRequest.md)
 - [CreateSnapshotExportTaskResponse](docs/CreateSnapshotExportTaskResponse.md)
 - [CreateSnapshotRequest](docs/CreateSnapshotRequest.md)
 - [CreateSnapshotResponse](docs/CreateSnapshotResponse.md)
 - [CreateSubnetRequest](docs/CreateSubnetRequest.md)
 - [CreateSubnetResponse](docs/CreateSubnetResponse.md)
 - [CreateTagsRequest](docs/CreateTagsRequest.md)
 - [CreateTagsResponse](docs/CreateTagsResponse.md)
 - [CreateVirtualGatewayRequest](docs/CreateVirtualGatewayRequest.md)
 - [CreateVirtualGatewayResponse](docs/CreateVirtualGatewayResponse.md)
 - [CreateVmsRequest](docs/CreateVmsRequest.md)
 - [CreateVmsResponse](docs/CreateVmsResponse.md)
 - [CreateVolumeRequest](docs/CreateVolumeRequest.md)
 - [CreateVolumeResponse](docs/CreateVolumeResponse.md)
 - [CreateVpnConnectionRequest](docs/CreateVpnConnectionRequest.md)
 - [CreateVpnConnectionResponse](docs/CreateVpnConnectionResponse.md)
 - [CreateVpnConnectionRouteRequest](docs/CreateVpnConnectionRouteRequest.md)
 - [CreateVpnConnectionRouteResponse](docs/CreateVpnConnectionRouteResponse.md)
 - [DeleteAccessKeyRequest](docs/DeleteAccessKeyRequest.md)
 - [DeleteAccessKeyResponse](docs/DeleteAccessKeyResponse.md)
 - [DeleteApiAccessRuleRequest](docs/DeleteApiAccessRuleRequest.md)
 - [DeleteApiAccessRuleResponse](docs/DeleteApiAccessRuleResponse.md)
 - [DeleteCaRequest](docs/DeleteCaRequest.md)
 - [DeleteCaResponse](docs/DeleteCaResponse.md)
 - [DeleteClientGatewayRequest](docs/DeleteClientGatewayRequest.md)
 - [DeleteClientGatewayResponse](docs/DeleteClientGatewayResponse.md)
 - [DeleteDhcpOptionsRequest](docs/DeleteDhcpOptionsRequest.md)
 - [DeleteDhcpOptionsResponse](docs/DeleteDhcpOptionsResponse.md)
 - [DeleteDirectLinkInterfaceRequest](docs/DeleteDirectLinkInterfaceRequest.md)
 - [DeleteDirectLinkInterfaceResponse](docs/DeleteDirectLinkInterfaceResponse.md)
 - [DeleteDirectLinkRequest](docs/DeleteDirectLinkRequest.md)
 - [DeleteDirectLinkResponse](docs/DeleteDirectLinkResponse.md)
 - [DeleteExportTaskRequest](docs/DeleteExportTaskRequest.md)
 - [DeleteExportTaskResponse](docs/DeleteExportTaskResponse.md)
 - [DeleteFlexibleGpuRequest](docs/DeleteFlexibleGpuRequest.md)
 - [DeleteFlexibleGpuResponse](docs/DeleteFlexibleGpuResponse.md)
 - [DeleteImageRequest](docs/DeleteImageRequest.md)
 - [DeleteImageResponse](docs/DeleteImageResponse.md)
 - [DeleteInternetServiceRequest](docs/DeleteInternetServiceRequest.md)
 - [DeleteInternetServiceResponse](docs/DeleteInternetServiceResponse.md)
 - [DeleteKeypairRequest](docs/DeleteKeypairRequest.md)
 - [DeleteKeypairResponse](docs/DeleteKeypairResponse.md)
 - [DeleteListenerRuleRequest](docs/DeleteListenerRuleRequest.md)
 - [DeleteListenerRuleResponse](docs/DeleteListenerRuleResponse.md)
 - [DeleteLoadBalancerListenersRequest](docs/DeleteLoadBalancerListenersRequest.md)
 - [DeleteLoadBalancerListenersResponse](docs/DeleteLoadBalancerListenersResponse.md)
 - [DeleteLoadBalancerPolicyRequest](docs/DeleteLoadBalancerPolicyRequest.md)
 - [DeleteLoadBalancerPolicyResponse](docs/DeleteLoadBalancerPolicyResponse.md)
 - [DeleteLoadBalancerRequest](docs/DeleteLoadBalancerRequest.md)
 - [DeleteLoadBalancerResponse](docs/DeleteLoadBalancerResponse.md)
 - [DeleteLoadBalancerTagsRequest](docs/DeleteLoadBalancerTagsRequest.md)
 - [DeleteLoadBalancerTagsResponse](docs/DeleteLoadBalancerTagsResponse.md)
 - [DeleteNatServiceRequest](docs/DeleteNatServiceRequest.md)
 - [DeleteNatServiceResponse](docs/DeleteNatServiceResponse.md)
 - [DeleteNetAccessPointRequest](docs/DeleteNetAccessPointRequest.md)
 - [DeleteNetAccessPointResponse](docs/DeleteNetAccessPointResponse.md)
 - [DeleteNetPeeringRequest](docs/DeleteNetPeeringRequest.md)
 - [DeleteNetPeeringResponse](docs/DeleteNetPeeringResponse.md)
 - [DeleteNetRequest](docs/DeleteNetRequest.md)
 - [DeleteNetResponse](docs/DeleteNetResponse.md)
 - [DeleteNicRequest](docs/DeleteNicRequest.md)
 - [DeleteNicResponse](docs/DeleteNicResponse.md)
 - [DeletePublicIpRequest](docs/DeletePublicIpRequest.md)
 - [DeletePublicIpResponse](docs/DeletePublicIpResponse.md)
 - [DeleteRouteRequest](docs/DeleteRouteRequest.md)
 - [DeleteRouteResponse](docs/DeleteRouteResponse.md)
 - [DeleteRouteTableRequest](docs/DeleteRouteTableRequest.md)
 - [DeleteRouteTableResponse](docs/DeleteRouteTableResponse.md)
 - [DeleteSecurityGroupRequest](docs/DeleteSecurityGroupRequest.md)
 - [DeleteSecurityGroupResponse](docs/DeleteSecurityGroupResponse.md)
 - [DeleteSecurityGroupRuleRequest](docs/DeleteSecurityGroupRuleRequest.md)
 - [DeleteSecurityGroupRuleResponse](docs/DeleteSecurityGroupRuleResponse.md)
 - [DeleteServerCertificateRequest](docs/DeleteServerCertificateRequest.md)
 - [DeleteServerCertificateResponse](docs/DeleteServerCertificateResponse.md)
 - [DeleteSnapshotRequest](docs/DeleteSnapshotRequest.md)
 - [DeleteSnapshotResponse](docs/DeleteSnapshotResponse.md)
 - [DeleteSubnetRequest](docs/DeleteSubnetRequest.md)
 - [DeleteSubnetResponse](docs/DeleteSubnetResponse.md)
 - [DeleteTagsRequest](docs/DeleteTagsRequest.md)
 - [DeleteTagsResponse](docs/DeleteTagsResponse.md)
 - [DeleteVirtualGatewayRequest](docs/DeleteVirtualGatewayRequest.md)
 - [DeleteVirtualGatewayResponse](docs/DeleteVirtualGatewayResponse.md)
 - [DeleteVmsRequest](docs/DeleteVmsRequest.md)
 - [DeleteVmsResponse](docs/DeleteVmsResponse.md)
 - [DeleteVolumeRequest](docs/DeleteVolumeRequest.md)
 - [DeleteVolumeResponse](docs/DeleteVolumeResponse.md)
 - [DeleteVpnConnectionRequest](docs/DeleteVpnConnectionRequest.md)
 - [DeleteVpnConnectionResponse](docs/DeleteVpnConnectionResponse.md)
 - [DeleteVpnConnectionRouteRequest](docs/DeleteVpnConnectionRouteRequest.md)
 - [DeleteVpnConnectionRouteResponse](docs/DeleteVpnConnectionRouteResponse.md)
 - [DeregisterVmsInLoadBalancerRequest](docs/DeregisterVmsInLoadBalancerRequest.md)
 - [DeregisterVmsInLoadBalancerResponse](docs/DeregisterVmsInLoadBalancerResponse.md)
 - [DhcpOptionsSet](docs/DhcpOptionsSet.md)
 - [DirectLink](docs/DirectLink.md)
 - [DirectLinkInterface](docs/DirectLinkInterface.md)
 - [DirectLinkInterfaces](docs/DirectLinkInterfaces.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Errors](docs/Errors.md)
 - [FiltersAccessKeys](docs/FiltersAccessKeys.md)
 - [FiltersApiAccessRule](docs/FiltersApiAccessRule.md)
 - [FiltersApiLog](docs/FiltersApiLog.md)
 - [FiltersCa](docs/FiltersCa.md)
 - [FiltersClientGateway](docs/FiltersClientGateway.md)
 - [FiltersDhcpOptions](docs/FiltersDhcpOptions.md)
 - [FiltersDirectLink](docs/FiltersDirectLink.md)
 - [FiltersDirectLinkInterface](docs/FiltersDirectLinkInterface.md)
 - [FiltersExportTask](docs/FiltersExportTask.md)
 - [FiltersFlexibleGpu](docs/FiltersFlexibleGpu.md)
 - [FiltersImage](docs/FiltersImage.md)
 - [FiltersInternetService](docs/FiltersInternetService.md)
 - [FiltersKeypair](docs/FiltersKeypair.md)
 - [FiltersListenerRule](docs/FiltersListenerRule.md)
 - [FiltersLoadBalancer](docs/FiltersLoadBalancer.md)
 - [FiltersNatService](docs/FiltersNatService.md)
 - [FiltersNet](docs/FiltersNet.md)
 - [FiltersNetAccessPoint](docs/FiltersNetAccessPoint.md)
 - [FiltersNetPeering](docs/FiltersNetPeering.md)
 - [FiltersNic](docs/FiltersNic.md)
 - [FiltersProductType](docs/FiltersProductType.md)
 - [FiltersPublicIp](docs/FiltersPublicIp.md)
 - [FiltersQuota](docs/FiltersQuota.md)
 - [FiltersRouteTable](docs/FiltersRouteTable.md)
 - [FiltersSecurityGroup](docs/FiltersSecurityGroup.md)
 - [FiltersServerCertificate](docs/FiltersServerCertificate.md)
 - [FiltersService](docs/FiltersService.md)
 - [FiltersSnapshot](docs/FiltersSnapshot.md)
 - [FiltersSubnet](docs/FiltersSubnet.md)
 - [FiltersSubregion](docs/FiltersSubregion.md)
 - [FiltersTag](docs/FiltersTag.md)
 - [FiltersVirtualGateway](docs/FiltersVirtualGateway.md)
 - [FiltersVm](docs/FiltersVm.md)
 - [FiltersVmType](docs/FiltersVmType.md)
 - [FiltersVmsState](docs/FiltersVmsState.md)
 - [FiltersVolume](docs/FiltersVolume.md)
 - [FiltersVpnConnection](docs/FiltersVpnConnection.md)
 - [FlexibleGpu](docs/FlexibleGpu.md)
 - [FlexibleGpuCatalog](docs/FlexibleGpuCatalog.md)
 - [HealthCheck](docs/HealthCheck.md)
 - [Image](docs/Image.md)
 - [ImageExportTask](docs/ImageExportTask.md)
 - [InternetService](docs/InternetService.md)
 - [Keypair](docs/Keypair.md)
 - [KeypairCreated](docs/KeypairCreated.md)
 - [LinkFlexibleGpuRequest](docs/LinkFlexibleGpuRequest.md)
 - [LinkFlexibleGpuResponse](docs/LinkFlexibleGpuResponse.md)
 - [LinkInternetServiceRequest](docs/LinkInternetServiceRequest.md)
 - [LinkInternetServiceResponse](docs/LinkInternetServiceResponse.md)
 - [LinkLoadBalancerBackendMachinesRequest](docs/LinkLoadBalancerBackendMachinesRequest.md)
 - [LinkLoadBalancerBackendMachinesResponse](docs/LinkLoadBalancerBackendMachinesResponse.md)
 - [LinkNic](docs/LinkNic.md)
 - [LinkNicLight](docs/LinkNicLight.md)
 - [LinkNicRequest](docs/LinkNicRequest.md)
 - [LinkNicResponse](docs/LinkNicResponse.md)
 - [LinkNicToUpdate](docs/LinkNicToUpdate.md)
 - [LinkPrivateIpsRequest](docs/LinkPrivateIpsRequest.md)
 - [LinkPrivateIpsResponse](docs/LinkPrivateIpsResponse.md)
 - [LinkPublicIp](docs/LinkPublicIp.md)
 - [LinkPublicIpLightForVm](docs/LinkPublicIpLightForVm.md)
 - [LinkPublicIpRequest](docs/LinkPublicIpRequest.md)
 - [LinkPublicIpResponse](docs/LinkPublicIpResponse.md)
 - [LinkRouteTable](docs/LinkRouteTable.md)
 - [LinkRouteTableRequest](docs/LinkRouteTableRequest.md)
 - [LinkRouteTableResponse](docs/LinkRouteTableResponse.md)
 - [LinkVirtualGatewayRequest](docs/LinkVirtualGatewayRequest.md)
 - [LinkVirtualGatewayResponse](docs/LinkVirtualGatewayResponse.md)
 - [LinkVolumeRequest](docs/LinkVolumeRequest.md)
 - [LinkVolumeResponse](docs/LinkVolumeResponse.md)
 - [LinkedVolume](docs/LinkedVolume.md)
 - [Listener](docs/Listener.md)
 - [ListenerForCreation](docs/ListenerForCreation.md)
 - [ListenerRule](docs/ListenerRule.md)
 - [ListenerRuleForCreation](docs/ListenerRuleForCreation.md)
 - [LoadBalancer](docs/LoadBalancer.md)
 - [LoadBalancerLight](docs/LoadBalancerLight.md)
 - [LoadBalancerStickyCookiePolicy](docs/LoadBalancerStickyCookiePolicy.md)
 - [LoadBalancerTag](docs/LoadBalancerTag.md)
 - [Location](docs/Location.md)
 - [Log](docs/Log.md)
 - [MaintenanceEvent](docs/MaintenanceEvent.md)
 - [NatService](docs/NatService.md)
 - [Net](docs/Net.md)
 - [NetAccessPoint](docs/NetAccessPoint.md)
 - [NetPeering](docs/NetPeering.md)
 - [NetPeeringState](docs/NetPeeringState.md)
 - [NetToVirtualGatewayLink](docs/NetToVirtualGatewayLink.md)
 - [Nic](docs/Nic.md)
 - [NicForVmCreation](docs/NicForVmCreation.md)
 - [NicLight](docs/NicLight.md)
 - [OsuApiKey](docs/OsuApiKey.md)
 - [OsuExportImageExportTask](docs/OsuExportImageExportTask.md)
 - [OsuExportSnapshotExportTask](docs/OsuExportSnapshotExportTask.md)
 - [OsuExportToCreate](docs/OsuExportToCreate.md)
 - [PermissionsOnResource](docs/PermissionsOnResource.md)
 - [PermissionsOnResourceCreation](docs/PermissionsOnResourceCreation.md)
 - [Phase1Options](docs/Phase1Options.md)
 - [Phase2Options](docs/Phase2Options.md)
 - [Placement](docs/Placement.md)
 - [PrivateIp](docs/PrivateIp.md)
 - [PrivateIpLight](docs/PrivateIpLight.md)
 - [PrivateIpLightForVm](docs/PrivateIpLightForVm.md)
 - [ProductType](docs/ProductType.md)
 - [PublicIp](docs/PublicIp.md)
 - [PublicIpLight](docs/PublicIpLight.md)
 - [Quota](docs/Quota.md)
 - [QuotaTypes](docs/QuotaTypes.md)
 - [ReadAccessKeysRequest](docs/ReadAccessKeysRequest.md)
 - [ReadAccessKeysResponse](docs/ReadAccessKeysResponse.md)
 - [ReadAccountsRequest](docs/ReadAccountsRequest.md)
 - [ReadAccountsResponse](docs/ReadAccountsResponse.md)
 - [ReadAdminPasswordRequest](docs/ReadAdminPasswordRequest.md)
 - [ReadAdminPasswordResponse](docs/ReadAdminPasswordResponse.md)
 - [ReadApiAccessPolicyRequest](docs/ReadApiAccessPolicyRequest.md)
 - [ReadApiAccessPolicyResponse](docs/ReadApiAccessPolicyResponse.md)
 - [ReadApiAccessRulesRequest](docs/ReadApiAccessRulesRequest.md)
 - [ReadApiAccessRulesResponse](docs/ReadApiAccessRulesResponse.md)
 - [ReadApiLogsRequest](docs/ReadApiLogsRequest.md)
 - [ReadApiLogsResponse](docs/ReadApiLogsResponse.md)
 - [ReadCasRequest](docs/ReadCasRequest.md)
 - [ReadCasResponse](docs/ReadCasResponse.md)
 - [ReadCatalogRequest](docs/ReadCatalogRequest.md)
 - [ReadCatalogResponse](docs/ReadCatalogResponse.md)
 - [ReadClientGatewaysRequest](docs/ReadClientGatewaysRequest.md)
 - [ReadClientGatewaysResponse](docs/ReadClientGatewaysResponse.md)
 - [ReadConsoleOutputRequest](docs/ReadConsoleOutputRequest.md)
 - [ReadConsoleOutputResponse](docs/ReadConsoleOutputResponse.md)
 - [ReadConsumptionAccountRequest](docs/ReadConsumptionAccountRequest.md)
 - [ReadConsumptionAccountResponse](docs/ReadConsumptionAccountResponse.md)
 - [ReadDhcpOptionsRequest](docs/ReadDhcpOptionsRequest.md)
 - [ReadDhcpOptionsResponse](docs/ReadDhcpOptionsResponse.md)
 - [ReadDirectLinkInterfacesRequest](docs/ReadDirectLinkInterfacesRequest.md)
 - [ReadDirectLinkInterfacesResponse](docs/ReadDirectLinkInterfacesResponse.md)
 - [ReadDirectLinksRequest](docs/ReadDirectLinksRequest.md)
 - [ReadDirectLinksResponse](docs/ReadDirectLinksResponse.md)
 - [ReadFlexibleGpuCatalogRequest](docs/ReadFlexibleGpuCatalogRequest.md)
 - [ReadFlexibleGpuCatalogResponse](docs/ReadFlexibleGpuCatalogResponse.md)
 - [ReadFlexibleGpusRequest](docs/ReadFlexibleGpusRequest.md)
 - [ReadFlexibleGpusResponse](docs/ReadFlexibleGpusResponse.md)
 - [ReadImageExportTasksRequest](docs/ReadImageExportTasksRequest.md)
 - [ReadImageExportTasksResponse](docs/ReadImageExportTasksResponse.md)
 - [ReadImagesRequest](docs/ReadImagesRequest.md)
 - [ReadImagesResponse](docs/ReadImagesResponse.md)
 - [ReadInternetServicesRequest](docs/ReadInternetServicesRequest.md)
 - [ReadInternetServicesResponse](docs/ReadInternetServicesResponse.md)
 - [ReadKeypairsRequest](docs/ReadKeypairsRequest.md)
 - [ReadKeypairsResponse](docs/ReadKeypairsResponse.md)
 - [ReadListenerRulesRequest](docs/ReadListenerRulesRequest.md)
 - [ReadListenerRulesResponse](docs/ReadListenerRulesResponse.md)
 - [ReadLoadBalancerTagsRequest](docs/ReadLoadBalancerTagsRequest.md)
 - [ReadLoadBalancerTagsResponse](docs/ReadLoadBalancerTagsResponse.md)
 - [ReadLoadBalancersRequest](docs/ReadLoadBalancersRequest.md)
 - [ReadLoadBalancersResponse](docs/ReadLoadBalancersResponse.md)
 - [ReadLocationsRequest](docs/ReadLocationsRequest.md)
 - [ReadLocationsResponse](docs/ReadLocationsResponse.md)
 - [ReadNatServicesRequest](docs/ReadNatServicesRequest.md)
 - [ReadNatServicesResponse](docs/ReadNatServicesResponse.md)
 - [ReadNetAccessPointServicesRequest](docs/ReadNetAccessPointServicesRequest.md)
 - [ReadNetAccessPointServicesResponse](docs/ReadNetAccessPointServicesResponse.md)
 - [ReadNetAccessPointsRequest](docs/ReadNetAccessPointsRequest.md)
 - [ReadNetAccessPointsResponse](docs/ReadNetAccessPointsResponse.md)
 - [ReadNetPeeringsRequest](docs/ReadNetPeeringsRequest.md)
 - [ReadNetPeeringsResponse](docs/ReadNetPeeringsResponse.md)
 - [ReadNetsRequest](docs/ReadNetsRequest.md)
 - [ReadNetsResponse](docs/ReadNetsResponse.md)
 - [ReadNicsRequest](docs/ReadNicsRequest.md)
 - [ReadNicsResponse](docs/ReadNicsResponse.md)
 - [ReadProductTypesRequest](docs/ReadProductTypesRequest.md)
 - [ReadProductTypesResponse](docs/ReadProductTypesResponse.md)
 - [ReadPublicCatalogRequest](docs/ReadPublicCatalogRequest.md)
 - [ReadPublicCatalogResponse](docs/ReadPublicCatalogResponse.md)
 - [ReadPublicIpRangesRequest](docs/ReadPublicIpRangesRequest.md)
 - [ReadPublicIpRangesResponse](docs/ReadPublicIpRangesResponse.md)
 - [ReadPublicIpsRequest](docs/ReadPublicIpsRequest.md)
 - [ReadPublicIpsResponse](docs/ReadPublicIpsResponse.md)
 - [ReadQuotasRequest](docs/ReadQuotasRequest.md)
 - [ReadQuotasResponse](docs/ReadQuotasResponse.md)
 - [ReadRegionsRequest](docs/ReadRegionsRequest.md)
 - [ReadRegionsResponse](docs/ReadRegionsResponse.md)
 - [ReadRouteTablesRequest](docs/ReadRouteTablesRequest.md)
 - [ReadRouteTablesResponse](docs/ReadRouteTablesResponse.md)
 - [ReadSecretAccessKeyRequest](docs/ReadSecretAccessKeyRequest.md)
 - [ReadSecretAccessKeyResponse](docs/ReadSecretAccessKeyResponse.md)
 - [ReadSecurityGroupsRequest](docs/ReadSecurityGroupsRequest.md)
 - [ReadSecurityGroupsResponse](docs/ReadSecurityGroupsResponse.md)
 - [ReadServerCertificatesRequest](docs/ReadServerCertificatesRequest.md)
 - [ReadServerCertificatesResponse](docs/ReadServerCertificatesResponse.md)
 - [ReadSnapshotExportTasksRequest](docs/ReadSnapshotExportTasksRequest.md)
 - [ReadSnapshotExportTasksResponse](docs/ReadSnapshotExportTasksResponse.md)
 - [ReadSnapshotsRequest](docs/ReadSnapshotsRequest.md)
 - [ReadSnapshotsResponse](docs/ReadSnapshotsResponse.md)
 - [ReadSubnetsRequest](docs/ReadSubnetsRequest.md)
 - [ReadSubnetsResponse](docs/ReadSubnetsResponse.md)
 - [ReadSubregionsRequest](docs/ReadSubregionsRequest.md)
 - [ReadSubregionsResponse](docs/ReadSubregionsResponse.md)
 - [ReadTagsRequest](docs/ReadTagsRequest.md)
 - [ReadTagsResponse](docs/ReadTagsResponse.md)
 - [ReadVirtualGatewaysRequest](docs/ReadVirtualGatewaysRequest.md)
 - [ReadVirtualGatewaysResponse](docs/ReadVirtualGatewaysResponse.md)
 - [ReadVmTypesRequest](docs/ReadVmTypesRequest.md)
 - [ReadVmTypesResponse](docs/ReadVmTypesResponse.md)
 - [ReadVmsHealthRequest](docs/ReadVmsHealthRequest.md)
 - [ReadVmsHealthResponse](docs/ReadVmsHealthResponse.md)
 - [ReadVmsRequest](docs/ReadVmsRequest.md)
 - [ReadVmsResponse](docs/ReadVmsResponse.md)
 - [ReadVmsStateRequest](docs/ReadVmsStateRequest.md)
 - [ReadVmsStateResponse](docs/ReadVmsStateResponse.md)
 - [ReadVolumesRequest](docs/ReadVolumesRequest.md)
 - [ReadVolumesResponse](docs/ReadVolumesResponse.md)
 - [ReadVpnConnectionsRequest](docs/ReadVpnConnectionsRequest.md)
 - [ReadVpnConnectionsResponse](docs/ReadVpnConnectionsResponse.md)
 - [RebootVmsRequest](docs/RebootVmsRequest.md)
 - [RebootVmsResponse](docs/RebootVmsResponse.md)
 - [Region](docs/Region.md)
 - [RegisterVmsInLoadBalancerRequest](docs/RegisterVmsInLoadBalancerRequest.md)
 - [RegisterVmsInLoadBalancerResponse](docs/RegisterVmsInLoadBalancerResponse.md)
 - [RejectNetPeeringRequest](docs/RejectNetPeeringRequest.md)
 - [RejectNetPeeringResponse](docs/RejectNetPeeringResponse.md)
 - [ResetAccountPasswordRequest](docs/ResetAccountPasswordRequest.md)
 - [ResetAccountPasswordResponse](docs/ResetAccountPasswordResponse.md)
 - [ResourceLoadBalancerTag](docs/ResourceLoadBalancerTag.md)
 - [ResourceTag](docs/ResourceTag.md)
 - [ResponseContext](docs/ResponseContext.md)
 - [Route](docs/Route.md)
 - [RouteLight](docs/RouteLight.md)
 - [RoutePropagatingVirtualGateway](docs/RoutePropagatingVirtualGateway.md)
 - [RouteTable](docs/RouteTable.md)
 - [SecurityGroup](docs/SecurityGroup.md)
 - [SecurityGroupLight](docs/SecurityGroupLight.md)
 - [SecurityGroupRule](docs/SecurityGroupRule.md)
 - [SecurityGroupsMember](docs/SecurityGroupsMember.md)
 - [SendResetPasswordEmailRequest](docs/SendResetPasswordEmailRequest.md)
 - [SendResetPasswordEmailResponse](docs/SendResetPasswordEmailResponse.md)
 - [ServerCertificate](docs/ServerCertificate.md)
 - [Service](docs/Service.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotExportTask](docs/SnapshotExportTask.md)
 - [SourceNet](docs/SourceNet.md)
 - [SourceSecurityGroup](docs/SourceSecurityGroup.md)
 - [StartVmsRequest](docs/StartVmsRequest.md)
 - [StartVmsResponse](docs/StartVmsResponse.md)
 - [StateComment](docs/StateComment.md)
 - [StopVmsRequest](docs/StopVmsRequest.md)
 - [StopVmsResponse](docs/StopVmsResponse.md)
 - [Subnet](docs/Subnet.md)
 - [Subregion](docs/Subregion.md)
 - [Tag](docs/Tag.md)
 - [UnlinkFlexibleGpuRequest](docs/UnlinkFlexibleGpuRequest.md)
 - [UnlinkFlexibleGpuResponse](docs/UnlinkFlexibleGpuResponse.md)
 - [UnlinkInternetServiceRequest](docs/UnlinkInternetServiceRequest.md)
 - [UnlinkInternetServiceResponse](docs/UnlinkInternetServiceResponse.md)
 - [UnlinkLoadBalancerBackendMachinesRequest](docs/UnlinkLoadBalancerBackendMachinesRequest.md)
 - [UnlinkLoadBalancerBackendMachinesResponse](docs/UnlinkLoadBalancerBackendMachinesResponse.md)
 - [UnlinkNicRequest](docs/UnlinkNicRequest.md)
 - [UnlinkNicResponse](docs/UnlinkNicResponse.md)
 - [UnlinkPrivateIpsRequest](docs/UnlinkPrivateIpsRequest.md)
 - [UnlinkPrivateIpsResponse](docs/UnlinkPrivateIpsResponse.md)
 - [UnlinkPublicIpRequest](docs/UnlinkPublicIpRequest.md)
 - [UnlinkPublicIpResponse](docs/UnlinkPublicIpResponse.md)
 - [UnlinkRouteTableRequest](docs/UnlinkRouteTableRequest.md)
 - [UnlinkRouteTableResponse](docs/UnlinkRouteTableResponse.md)
 - [UnlinkVirtualGatewayRequest](docs/UnlinkVirtualGatewayRequest.md)
 - [UnlinkVirtualGatewayResponse](docs/UnlinkVirtualGatewayResponse.md)
 - [UnlinkVolumeRequest](docs/UnlinkVolumeRequest.md)
 - [UnlinkVolumeResponse](docs/UnlinkVolumeResponse.md)
 - [UpdateAccessKeyRequest](docs/UpdateAccessKeyRequest.md)
 - [UpdateAccessKeyResponse](docs/UpdateAccessKeyResponse.md)
 - [UpdateAccountRequest](docs/UpdateAccountRequest.md)
 - [UpdateAccountResponse](docs/UpdateAccountResponse.md)
 - [UpdateApiAccessPolicyRequest](docs/UpdateApiAccessPolicyRequest.md)
 - [UpdateApiAccessPolicyResponse](docs/UpdateApiAccessPolicyResponse.md)
 - [UpdateApiAccessRuleRequest](docs/UpdateApiAccessRuleRequest.md)
 - [UpdateApiAccessRuleResponse](docs/UpdateApiAccessRuleResponse.md)
 - [UpdateCaRequest](docs/UpdateCaRequest.md)
 - [UpdateCaResponse](docs/UpdateCaResponse.md)
 - [UpdateFlexibleGpuRequest](docs/UpdateFlexibleGpuRequest.md)
 - [UpdateFlexibleGpuResponse](docs/UpdateFlexibleGpuResponse.md)
 - [UpdateImageRequest](docs/UpdateImageRequest.md)
 - [UpdateImageResponse](docs/UpdateImageResponse.md)
 - [UpdateListenerRuleRequest](docs/UpdateListenerRuleRequest.md)
 - [UpdateListenerRuleResponse](docs/UpdateListenerRuleResponse.md)
 - [UpdateLoadBalancerRequest](docs/UpdateLoadBalancerRequest.md)
 - [UpdateLoadBalancerResponse](docs/UpdateLoadBalancerResponse.md)
 - [UpdateNetAccessPointRequest](docs/UpdateNetAccessPointRequest.md)
 - [UpdateNetAccessPointResponse](docs/UpdateNetAccessPointResponse.md)
 - [UpdateNetRequest](docs/UpdateNetRequest.md)
 - [UpdateNetResponse](docs/UpdateNetResponse.md)
 - [UpdateNicRequest](docs/UpdateNicRequest.md)
 - [UpdateNicResponse](docs/UpdateNicResponse.md)
 - [UpdateRoutePropagationRequest](docs/UpdateRoutePropagationRequest.md)
 - [UpdateRoutePropagationResponse](docs/UpdateRoutePropagationResponse.md)
 - [UpdateRouteRequest](docs/UpdateRouteRequest.md)
 - [UpdateRouteResponse](docs/UpdateRouteResponse.md)
 - [UpdateServerCertificateRequest](docs/UpdateServerCertificateRequest.md)
 - [UpdateServerCertificateResponse](docs/UpdateServerCertificateResponse.md)
 - [UpdateSnapshotRequest](docs/UpdateSnapshotRequest.md)
 - [UpdateSnapshotResponse](docs/UpdateSnapshotResponse.md)
 - [UpdateSubnetRequest](docs/UpdateSubnetRequest.md)
 - [UpdateSubnetResponse](docs/UpdateSubnetResponse.md)
 - [UpdateVmRequest](docs/UpdateVmRequest.md)
 - [UpdateVmResponse](docs/UpdateVmResponse.md)
 - [UpdateVolumeRequest](docs/UpdateVolumeRequest.md)
 - [UpdateVolumeResponse](docs/UpdateVolumeResponse.md)
 - [UpdateVpnConnectionRequest](docs/UpdateVpnConnectionRequest.md)
 - [UpdateVpnConnectionResponse](docs/UpdateVpnConnectionResponse.md)
 - [VgwTelemetry](docs/VgwTelemetry.md)
 - [VirtualGateway](docs/VirtualGateway.md)
 - [Vm](docs/Vm.md)
 - [VmState](docs/VmState.md)
 - [VmStates](docs/VmStates.md)
 - [VmType](docs/VmType.md)
 - [Volume](docs/Volume.md)
 - [VpnConnection](docs/VpnConnection.md)
 - [VpnOptions](docs/VpnOptions.md)
 - [With](docs/With.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

support@outscale.com

