## Release Notes version 0_0_8

Previously this lib exported a trait that required to be implemented by a type. However the current version is just a group of functions available. There is no trait.

The library has abstraction layer on top called **tasks**. I have added the first task called "create_dir_structure". 

## Understanding Tasks
---
> A task is a "sequence of instructions" built on top of Brown library. All the data required for the operation is obtained from the user at the begining and then the operation is **run**

Here is a test for the new task::create_dir_structure

```rust
use brown;

#[cfg(test)]
#[test]
fn use_fn(){
    let paths_list = vec!
            [ 
                "/hulkfolder" ,
                "./data2", 
                "si?te" ,
                "data", 
                "site/images", 
                "hulkfolder/templates" ,
            ];
let parent_folder = "cds";
    let _a = brown::create_dir_structure::
    run(parent_folder,paths_list);
    //====== tests
    assert_eq!(true,brown::path_exists("cds/data"));
    assert_eq!(true,brown::path_exists("cds/site/images"));
    assert_eq!(true,brown::path_exists("cds/hulkfolder/templates"));
//===clean up
    let destroy = brown::remove_dir_brute(parent_folder).unwrap();
    assert_eq!(destroy,true);
}
```
