use std::{
    fs::remove_file,
    path::{Path, PathBuf},
    process,
};

#[derive(Debug, Clone)]
pub struct TempFile {
    path: PathBuf,
}

impl TempFile {
    pub fn create() -> Self {
        let thread_id: String = format!("{:?}", std::thread::current().id())
            .chars()
            .filter(|c| c.is_alphanumeric())
            .collect();

        let path = format!("/tmp/otarustlings_{}_{}", process::id(), thread_id).into();
        Self { path }
    }

    pub fn path(&self) -> &PathBuf {
        &self.path
    }
}

impl AsRef<Path> for TempFile {
    fn as_ref(&self) -> &Path {
        self.path.as_ref()
    }
}

impl Drop for TempFile {
    fn drop(&mut self) {
        let _ignored = remove_file(&self.path);
    }
}
