use console::Term;
use dialoguer::theme::ColorfulTheme;
use otarustlings::{
    exercise::{compile, run, CompileError},
    menu::MenuBuilder,
    state::State,
};
use std::path::Path;

#[tokio::main]
async fn main() -> anyhow::Result<()> {
    // let (_watcher, rx) = create_watcher("./src").await?;

    // let watch_handle = tokio::spawn(async move {
    //     handle_watch(rx).await.unwrap()
    // });
    // let input_handle = tokio::spawn(async {
    //     handle_input().await.unwrap()
    // });

    // when starting the app a tree of exercises is shown from which
    // the user can select to continue where they left off or manually
    // select which exercise to start on.
    //
    // after selecting the exercise the screen is cleared and
    // otarustligs starts watching changes to that file and
    // automatically recompiles on changes.  pressing 'q' or ESC will
    // lead back to the menu.  pressing '?' will show keyboard
    // shortcuts.  once the exercise is finished, it gets marked in
    // the state and otarustlings continues with the next exercise
    // except for last exercise of the week where the menu of the next
    // week is shown.
    //
    // all folders and exercises have a marker next to them to show if
    // they have been started or are done
    //
    // otarustlings has a --help which explains how to do the exercises

    let mut prev_sel = 0;
    loop {
        let mut state = State::scan_open_default("exercises").await?;

        let theme = ColorfulTheme::default();
        let menu = MenuBuilder::default()
            .default_index(prev_sel)
            .items(&state.0)
            .theme(&theme)
            .build()
            .unwrap();

        let sel = if let Some(sel) = menu.interact(&Term::stderr())? {
            sel
        } else {
            break;
        };
        let mut exercise = state
            .0
            .iter()
            .nth(sel)
            .expect("sel to be within range")
            .clone();

        match compile(Path::new("exercises/").join(&exercise.path)) {
            Ok(tempfile) => match run(tempfile) {
                Ok(output) => {
                    println!("{}", output);
                    exercise.exercise_state.complete_exercise();
                }
                Err(output) => {
                    println!("{}", output);
                }
            },
            Err(CompileError::OutputError(output)) => {
                println!("{}", output.stderr);
            }
            Err(CompileError::IOError(output)) => {
                println!("{}", output);
            }
        }

        assert!(
            state.0.remove(&exercise), // remove returns true if the item existed
            "state did not contain the exercise"
        );
        exercise.exercise_state.start_exercise();
        state.0.insert(exercise);

        state.save().await?;
        prev_sel = sel;
    }

    // loop {
    //     let mut state = State::scan_open_default("exercises").await?;

    //     let theme = ColorfulTheme::default();
    //     let temp = state.clone(); // FIXME (implement toOwned for Menu?)
    //     let index = prev_ex_path
    //         .and_then(|prev: PathBuf| temp.0.iter().position(|i| i.0 == &prev))
    //         .unwrap_or(0);
    //     let items: Vec<_> = temp.iter().collect();
    //     let menu = MenuBuilder::default()
    //         .default_index(index)
    //         .items(&items)
    //         .theme(&theme)
    //         .build()
    //         .unwrap();

    //     if let Some(item) = menu.interact(&Term::stderr())? {
    //         state
    //             .0
    //             .get_mut(item.0)
    //             .expect("state to contain exercise")
    //             .start_exercise();
    //         prev_ex_path = Some(item.0.clone());
    //         match compile(Path::new("exercises/").join(item.0)) {
    //             Ok(tempfile) => match run(tempfile) {
    //                 Ok(output) => {
    //                     println!("{}", output);
    //                     state
    //                         .0
    //                         .get_mut(item.0)
    //                         .expect("state to contain exercise")
    //                         .complete_exercise();
    //                 }
    //                 Err(output) => {
    //                     println!("{}", output);
    //                 }
    //             },
    //             Err(CompileError::OutputError(output)) => {
    //                 println!("{}", output.stderr);
    //             }
    //             Err(CompileError::IOError(output)) => {
    //                 println!("{}", output);
    //             }
    //         }

    //         state.save().await?;
    //     } else {
    //         break;
    //     }
    // }
    Ok(())
}
