use notify::{DebouncedEvent, RecommendedWatcher, RecursiveMode, Watcher};
use std::{
    error, io,
    path::Path,
    sync::mpsc::{self, Receiver, RecvError},
    time::Duration,
};
use tokio::io::{stdin, AsyncBufReadExt, BufReader};

pub async fn handle_watch(rx: Receiver<DebouncedEvent>) -> Result<(), RecvError> {
    loop {
        match rx.recv()? {
            DebouncedEvent::Create(b) | DebouncedEvent::Chmod(b) | DebouncedEvent::Write(b) => {
                println!("somtehing happende at {:?}", b);
            }
            _ => {}
        }
    }
}

pub async fn create_watcher<T: AsRef<Path>>(
    path: T,
) -> Result<(RecommendedWatcher, Receiver<DebouncedEvent>), Box<dyn error::Error>> {
    let (tx, rx) = mpsc::channel();

    let mut watcher: RecommendedWatcher = Watcher::new(tx, Duration::from_secs(2))?;
    watcher.watch(path, RecursiveMode::Recursive)?;

    Ok((watcher, rx))
}

/// Handle keyboard input commands like `list`
pub async fn handle_input() -> Result<(), io::Error> {
    let mut reader = BufReader::new(stdin());
    let mut buffer = String::new();

    loop {
        // truncate input buffer to clear old lines
        buffer.truncate(0);
        reader.read_line(&mut buffer).await?;

        println!("Input was: {:?}", buffer);
    }
}
