use console::Term;
use dialoguer::theme::ColorfulTheme;
use otarustlings::{
    exercise::{compile, run, CompileError},
    menu::MenuBuilder,
    state::State,
};
use std::path::Path;

#[tokio::main]
async fn main() -> anyhow::Result<()> {
    // let (_watcher, rx) = create_watcher("./src").await?;

    // let watch_handle = tokio::spawn(async move {
    //     handle_watch(rx).await.unwrap()
    // });
    // let input_handle = tokio::spawn(async {
    //     handle_input().await.unwrap()
    // });

    // when starting the app a tree of exercises is shown from which the user
    // can select to continue where they left off or manually select which
    // exercise to start on. otarustligs watches
    // changes to that file and automatically recompiles on change.
    // once the exercise is finished, it gets marked in the state and otarustlings
    // continues with the next exercise except for last exercise of the week.
    //
    // on first launch when there is no state file, otarustlings starts from the first task.
    // first exercise is trivial and demonstrates the use of otarustlings.
    //
    // the user can mark a task as done/wont do
    //
    // all trees and exercises have a marker next to them to show if they have been started or are done
    //
    // otarustlings needs --help which explains how to do the exercises

    let mut state = State::scan_open_default("exercises").await?;

    let theme = ColorfulTheme::default();
    let temp = state.clone(); // FIXME (implement toOwned for Menu?)
    let items: Vec<_> = temp.iter_exercises().collect();
    let menu = MenuBuilder::default()
        .default_index(0)
        .items(&items)
        .theme(&theme)
        .build()
        .unwrap();

    while let Some(item) = menu.interact(&Term::stderr())? {
        state
            .0
            // FIXME .path is only available on Exercises, but not MenuItems
            .get_mut(item.path)
            .expect("state to contain exercise")
            .start_exercise();

        match compile(Path::new("exercises/").join(item.path)) {
            Ok(tempfile) => match run(tempfile) {
                Ok(output) => {
                    println!("{}", output);
                    state
                        .0
                        .get_mut(item.path)
                        .expect("state to contain exercise")
                        .complete_exercise();
                }
                Err(output) => {
                    println!("{}", output);
                }
            },
            Err(CompileError::OutputError(output)) => {
                println!("{}", output.stderr);
            }
            Err(CompileError::IOError(output)) => {
                println!("{}", output);
            }
        }

        state.save().await?;
    }
    // join_all(
    //     [watch_handle, input_handle]
    // ).await;

    Ok(())
}
