// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files
// DO NOT EDIT

use ostree_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["ostree-1"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "OstreeAsyncProgressClass",
        Layout {
            size: size_of::<OstreeAsyncProgressClass>(),
            alignment: align_of::<OstreeAsyncProgressClass>(),
        },
    ),
    (
        "OstreeChecksumFlags",
        Layout {
            size: size_of::<OstreeChecksumFlags>(),
            alignment: align_of::<OstreeChecksumFlags>(),
        },
    ),
    (
        "OstreeCollectionRef",
        Layout {
            size: size_of::<OstreeCollectionRef>(),
            alignment: align_of::<OstreeCollectionRef>(),
        },
    ),
    (
        "OstreeCollectionRefv",
        Layout {
            size: size_of::<OstreeCollectionRefv>(),
            alignment: align_of::<OstreeCollectionRefv>(),
        },
    ),
    (
        "OstreeCommitSizesEntry",
        Layout {
            size: size_of::<OstreeCommitSizesEntry>(),
            alignment: align_of::<OstreeCommitSizesEntry>(),
        },
    ),
    (
        "OstreeContentWriterClass",
        Layout {
            size: size_of::<OstreeContentWriterClass>(),
            alignment: align_of::<OstreeContentWriterClass>(),
        },
    ),
    (
        "OstreeDeploymentUnlockedState",
        Layout {
            size: size_of::<OstreeDeploymentUnlockedState>(),
            alignment: align_of::<OstreeDeploymentUnlockedState>(),
        },
    ),
    (
        "OstreeDiffDirsOptions",
        Layout {
            size: size_of::<OstreeDiffDirsOptions>(),
            alignment: align_of::<OstreeDiffDirsOptions>(),
        },
    ),
    (
        "OstreeDiffFlags",
        Layout {
            size: size_of::<OstreeDiffFlags>(),
            alignment: align_of::<OstreeDiffFlags>(),
        },
    ),
    (
        "OstreeDiffItem",
        Layout {
            size: size_of::<OstreeDiffItem>(),
            alignment: align_of::<OstreeDiffItem>(),
        },
    ),
    (
        "OstreeGpgError",
        Layout {
            size: size_of::<OstreeGpgError>(),
            alignment: align_of::<OstreeGpgError>(),
        },
    ),
    (
        "OstreeGpgSignatureAttr",
        Layout {
            size: size_of::<OstreeGpgSignatureAttr>(),
            alignment: align_of::<OstreeGpgSignatureAttr>(),
        },
    ),
    (
        "OstreeGpgSignatureFormatFlags",
        Layout {
            size: size_of::<OstreeGpgSignatureFormatFlags>(),
            alignment: align_of::<OstreeGpgSignatureFormatFlags>(),
        },
    ),
    (
        "OstreeMutableTreeClass",
        Layout {
            size: size_of::<OstreeMutableTreeClass>(),
            alignment: align_of::<OstreeMutableTreeClass>(),
        },
    ),
    (
        "OstreeMutableTreeIter",
        Layout {
            size: size_of::<OstreeMutableTreeIter>(),
            alignment: align_of::<OstreeMutableTreeIter>(),
        },
    ),
    (
        "OstreeObjectType",
        Layout {
            size: size_of::<OstreeObjectType>(),
            alignment: align_of::<OstreeObjectType>(),
        },
    ),
    (
        "OstreeRepoCheckoutAtOptions",
        Layout {
            size: size_of::<OstreeRepoCheckoutAtOptions>(),
            alignment: align_of::<OstreeRepoCheckoutAtOptions>(),
        },
    ),
    (
        "OstreeRepoCheckoutFilterResult",
        Layout {
            size: size_of::<OstreeRepoCheckoutFilterResult>(),
            alignment: align_of::<OstreeRepoCheckoutFilterResult>(),
        },
    ),
    (
        "OstreeRepoCheckoutMode",
        Layout {
            size: size_of::<OstreeRepoCheckoutMode>(),
            alignment: align_of::<OstreeRepoCheckoutMode>(),
        },
    ),
    (
        "OstreeRepoCheckoutOverwriteMode",
        Layout {
            size: size_of::<OstreeRepoCheckoutOverwriteMode>(),
            alignment: align_of::<OstreeRepoCheckoutOverwriteMode>(),
        },
    ),
    (
        "OstreeRepoCommitFilterResult",
        Layout {
            size: size_of::<OstreeRepoCommitFilterResult>(),
            alignment: align_of::<OstreeRepoCommitFilterResult>(),
        },
    ),
    (
        "OstreeRepoCommitIterResult",
        Layout {
            size: size_of::<OstreeRepoCommitIterResult>(),
            alignment: align_of::<OstreeRepoCommitIterResult>(),
        },
    ),
    (
        "OstreeRepoCommitModifierFlags",
        Layout {
            size: size_of::<OstreeRepoCommitModifierFlags>(),
            alignment: align_of::<OstreeRepoCommitModifierFlags>(),
        },
    ),
    (
        "OstreeRepoCommitState",
        Layout {
            size: size_of::<OstreeRepoCommitState>(),
            alignment: align_of::<OstreeRepoCommitState>(),
        },
    ),
    (
        "OstreeRepoCommitTraverseFlags",
        Layout {
            size: size_of::<OstreeRepoCommitTraverseFlags>(),
            alignment: align_of::<OstreeRepoCommitTraverseFlags>(),
        },
    ),
    (
        "OstreeRepoCommitTraverseIter",
        Layout {
            size: size_of::<OstreeRepoCommitTraverseIter>(),
            alignment: align_of::<OstreeRepoCommitTraverseIter>(),
        },
    ),
    (
        "OstreeRepoFileClass",
        Layout {
            size: size_of::<OstreeRepoFileClass>(),
            alignment: align_of::<OstreeRepoFileClass>(),
        },
    ),
    (
        "OstreeRepoFinderAvahiClass",
        Layout {
            size: size_of::<OstreeRepoFinderAvahiClass>(),
            alignment: align_of::<OstreeRepoFinderAvahiClass>(),
        },
    ),
    (
        "OstreeRepoFinderConfigClass",
        Layout {
            size: size_of::<OstreeRepoFinderConfigClass>(),
            alignment: align_of::<OstreeRepoFinderConfigClass>(),
        },
    ),
    (
        "OstreeRepoFinderInterface",
        Layout {
            size: size_of::<OstreeRepoFinderInterface>(),
            alignment: align_of::<OstreeRepoFinderInterface>(),
        },
    ),
    (
        "OstreeRepoFinderMountClass",
        Layout {
            size: size_of::<OstreeRepoFinderMountClass>(),
            alignment: align_of::<OstreeRepoFinderMountClass>(),
        },
    ),
    (
        "OstreeRepoFinderOverrideClass",
        Layout {
            size: size_of::<OstreeRepoFinderOverrideClass>(),
            alignment: align_of::<OstreeRepoFinderOverrideClass>(),
        },
    ),
    (
        "OstreeRepoFinderResult",
        Layout {
            size: size_of::<OstreeRepoFinderResult>(),
            alignment: align_of::<OstreeRepoFinderResult>(),
        },
    ),
    (
        "OstreeRepoFinderResultv",
        Layout {
            size: size_of::<OstreeRepoFinderResultv>(),
            alignment: align_of::<OstreeRepoFinderResultv>(),
        },
    ),
    (
        "OstreeRepoListObjectsFlags",
        Layout {
            size: size_of::<OstreeRepoListObjectsFlags>(),
            alignment: align_of::<OstreeRepoListObjectsFlags>(),
        },
    ),
    (
        "OstreeRepoListRefsExtFlags",
        Layout {
            size: size_of::<OstreeRepoListRefsExtFlags>(),
            alignment: align_of::<OstreeRepoListRefsExtFlags>(),
        },
    ),
    (
        "OstreeRepoMode",
        Layout {
            size: size_of::<OstreeRepoMode>(),
            alignment: align_of::<OstreeRepoMode>(),
        },
    ),
    (
        "OstreeRepoPruneFlags",
        Layout {
            size: size_of::<OstreeRepoPruneFlags>(),
            alignment: align_of::<OstreeRepoPruneFlags>(),
        },
    ),
    (
        "OstreeRepoPruneOptions",
        Layout {
            size: size_of::<OstreeRepoPruneOptions>(),
            alignment: align_of::<OstreeRepoPruneOptions>(),
        },
    ),
    (
        "OstreeRepoPullFlags",
        Layout {
            size: size_of::<OstreeRepoPullFlags>(),
            alignment: align_of::<OstreeRepoPullFlags>(),
        },
    ),
    (
        "OstreeRepoRemoteChange",
        Layout {
            size: size_of::<OstreeRepoRemoteChange>(),
            alignment: align_of::<OstreeRepoRemoteChange>(),
        },
    ),
    (
        "OstreeRepoResolveRevExtFlags",
        Layout {
            size: size_of::<OstreeRepoResolveRevExtFlags>(),
            alignment: align_of::<OstreeRepoResolveRevExtFlags>(),
        },
    ),
    (
        "OstreeRepoTransactionStats",
        Layout {
            size: size_of::<OstreeRepoTransactionStats>(),
            alignment: align_of::<OstreeRepoTransactionStats>(),
        },
    ),
    (
        "OstreeSePolicyRestoreconFlags",
        Layout {
            size: size_of::<OstreeSePolicyRestoreconFlags>(),
            alignment: align_of::<OstreeSePolicyRestoreconFlags>(),
        },
    ),
    (
        "OstreeSignInterface",
        Layout {
            size: size_of::<OstreeSignInterface>(),
            alignment: align_of::<OstreeSignInterface>(),
        },
    ),
    (
        "OstreeStaticDeltaGenerateOpt",
        Layout {
            size: size_of::<OstreeStaticDeltaGenerateOpt>(),
            alignment: align_of::<OstreeStaticDeltaGenerateOpt>(),
        },
    ),
    (
        "OstreeStaticDeltaIndexFlags",
        Layout {
            size: size_of::<OstreeStaticDeltaIndexFlags>(),
            alignment: align_of::<OstreeStaticDeltaIndexFlags>(),
        },
    ),
    (
        "OstreeSysrootDeployTreeOpts",
        Layout {
            size: size_of::<OstreeSysrootDeployTreeOpts>(),
            alignment: align_of::<OstreeSysrootDeployTreeOpts>(),
        },
    ),
    (
        "OstreeSysrootSimpleWriteDeploymentFlags",
        Layout {
            size: size_of::<OstreeSysrootSimpleWriteDeploymentFlags>(),
            alignment: align_of::<OstreeSysrootSimpleWriteDeploymentFlags>(),
        },
    ),
    (
        "OstreeSysrootUpgraderFlags",
        Layout {
            size: size_of::<OstreeSysrootUpgraderFlags>(),
            alignment: align_of::<OstreeSysrootUpgraderFlags>(),
        },
    ),
    (
        "OstreeSysrootUpgraderPullFlags",
        Layout {
            size: size_of::<OstreeSysrootUpgraderPullFlags>(),
            alignment: align_of::<OstreeSysrootUpgraderPullFlags>(),
        },
    ),
    (
        "OstreeSysrootWriteDeploymentsOpts",
        Layout {
            size: size_of::<OstreeSysrootWriteDeploymentsOpts>(),
            alignment: align_of::<OstreeSysrootWriteDeploymentsOpts>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(guint) OSTREE_CHECKSUM_FLAGS_IGNORE_XATTRS", "1"),
    ("(guint) OSTREE_CHECKSUM_FLAGS_NONE", "0"),
    ("OSTREE_COMMIT_GVARIANT_STRING", "(a{sv}aya(say)sstayay)"),
    ("OSTREE_COMMIT_META_KEY_ARCHITECTURE", "ostree.architecture"),
    (
        "OSTREE_COMMIT_META_KEY_COLLECTION_BINDING",
        "ostree.collection-binding",
    ),
    ("OSTREE_COMMIT_META_KEY_ENDOFLIFE", "ostree.endoflife"),
    (
        "OSTREE_COMMIT_META_KEY_ENDOFLIFE_REBASE",
        "ostree.endoflife-rebase",
    ),
    ("OSTREE_COMMIT_META_KEY_REF_BINDING", "ostree.ref-binding"),
    ("OSTREE_COMMIT_META_KEY_SOURCE_TITLE", "ostree.source-title"),
    ("OSTREE_COMMIT_META_KEY_VERSION", "version"),
    ("(gint) OSTREE_DEPLOYMENT_UNLOCKED_DEVELOPMENT", "1"),
    ("(gint) OSTREE_DEPLOYMENT_UNLOCKED_HOTFIX", "2"),
    ("(gint) OSTREE_DEPLOYMENT_UNLOCKED_NONE", "0"),
    ("(gint) OSTREE_DEPLOYMENT_UNLOCKED_TRANSIENT", "3"),
    ("(guint) OSTREE_DIFF_FLAGS_IGNORE_XATTRS", "1"),
    ("(guint) OSTREE_DIFF_FLAGS_NONE", "0"),
    ("OSTREE_DIRMETA_GVARIANT_STRING", "(uuua(ayay))"),
    ("OSTREE_FILEMETA_GVARIANT_STRING", "(uuua(ayay))"),
    ("(gint) OSTREE_GPG_ERROR_EXPIRED_KEY", "4"),
    ("(gint) OSTREE_GPG_ERROR_EXPIRED_SIGNATURE", "3"),
    ("(gint) OSTREE_GPG_ERROR_INVALID_SIGNATURE", "1"),
    ("(gint) OSTREE_GPG_ERROR_MISSING_KEY", "2"),
    ("(gint) OSTREE_GPG_ERROR_NO_SIGNATURE", "0"),
    ("(gint) OSTREE_GPG_ERROR_REVOKED_KEY", "5"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_EXP_TIMESTAMP", "7"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_FINGERPRINT", "5"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_FINGERPRINT_PRIMARY", "12"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_HASH_ALGO_NAME", "9"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_KEY_EXPIRED", "2"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_KEY_EXP_TIMESTAMP", "13"),
    (
        "(gint) OSTREE_GPG_SIGNATURE_ATTR_KEY_EXP_TIMESTAMP_PRIMARY",
        "14",
    ),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_KEY_MISSING", "4"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_KEY_REVOKED", "3"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_PUBKEY_ALGO_NAME", "8"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_SIG_EXPIRED", "1"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_TIMESTAMP", "6"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_USER_EMAIL", "11"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_USER_NAME", "10"),
    ("(gint) OSTREE_GPG_SIGNATURE_ATTR_VALID", "0"),
    ("(guint) OSTREE_GPG_SIGNATURE_FORMAT_DEFAULT", "0"),
    ("OSTREE_MAX_METADATA_SIZE", "10485760"),
    ("OSTREE_MAX_METADATA_WARN_SIZE", "7340032"),
    ("OSTREE_METADATA_KEY_BOOTABLE", "ostree.bootable"),
    ("OSTREE_METADATA_KEY_LINUX", "ostree.linux"),
    (
        "OSTREE_META_KEY_DEPLOY_COLLECTION_ID",
        "ostree.deploy-collection-id",
    ),
    ("(gint) OSTREE_OBJECT_TYPE_COMMIT", "4"),
    ("(gint) OSTREE_OBJECT_TYPE_COMMIT_META", "6"),
    ("(gint) OSTREE_OBJECT_TYPE_DIR_META", "3"),
    ("(gint) OSTREE_OBJECT_TYPE_DIR_TREE", "2"),
    ("(gint) OSTREE_OBJECT_TYPE_FILE", "1"),
    ("(gint) OSTREE_OBJECT_TYPE_PAYLOAD_LINK", "7"),
    ("(gint) OSTREE_OBJECT_TYPE_TOMBSTONE_COMMIT", "5"),
    ("OSTREE_ORIGIN_TRANSIENT_GROUP", "libostree-transient"),
    ("(gint) OSTREE_REPO_CHECKOUT_FILTER_ALLOW", "0"),
    ("(gint) OSTREE_REPO_CHECKOUT_FILTER_SKIP", "1"),
    ("(gint) OSTREE_REPO_CHECKOUT_MODE_NONE", "0"),
    ("(gint) OSTREE_REPO_CHECKOUT_MODE_USER", "1"),
    ("(gint) OSTREE_REPO_CHECKOUT_OVERWRITE_ADD_FILES", "2"),
    ("(gint) OSTREE_REPO_CHECKOUT_OVERWRITE_NONE", "0"),
    ("(gint) OSTREE_REPO_CHECKOUT_OVERWRITE_UNION_FILES", "1"),
    ("(gint) OSTREE_REPO_CHECKOUT_OVERWRITE_UNION_IDENTICAL", "3"),
    ("(gint) OSTREE_REPO_COMMIT_FILTER_ALLOW", "0"),
    ("(gint) OSTREE_REPO_COMMIT_FILTER_SKIP", "1"),
    ("(gint) OSTREE_REPO_COMMIT_ITER_RESULT_DIR", "3"),
    ("(gint) OSTREE_REPO_COMMIT_ITER_RESULT_END", "1"),
    ("(gint) OSTREE_REPO_COMMIT_ITER_RESULT_ERROR", "0"),
    ("(gint) OSTREE_REPO_COMMIT_ITER_RESULT_FILE", "2"),
    (
        "(guint) OSTREE_REPO_COMMIT_MODIFIER_FLAGS_CANONICAL_PERMISSIONS",
        "4",
    ),
    ("(guint) OSTREE_REPO_COMMIT_MODIFIER_FLAGS_CONSUME", "16"),
    (
        "(guint) OSTREE_REPO_COMMIT_MODIFIER_FLAGS_DEVINO_CANONICAL",
        "32",
    ),
    (
        "(guint) OSTREE_REPO_COMMIT_MODIFIER_FLAGS_ERROR_ON_UNLABELED",
        "8",
    ),
    (
        "(guint) OSTREE_REPO_COMMIT_MODIFIER_FLAGS_GENERATE_SIZES",
        "2",
    ),
    ("(guint) OSTREE_REPO_COMMIT_MODIFIER_FLAGS_NONE", "0"),
    ("(guint) OSTREE_REPO_COMMIT_MODIFIER_FLAGS_SKIP_XATTRS", "1"),
    ("(guint) OSTREE_REPO_COMMIT_STATE_FSCK_PARTIAL", "2"),
    ("(guint) OSTREE_REPO_COMMIT_STATE_NORMAL", "0"),
    ("(guint) OSTREE_REPO_COMMIT_STATE_PARTIAL", "1"),
    ("(guint) OSTREE_REPO_COMMIT_TRAVERSE_FLAG_NONE", "1"),
    ("(guint) OSTREE_REPO_LIST_OBJECTS_ALL", "4"),
    ("(guint) OSTREE_REPO_LIST_OBJECTS_LOOSE", "1"),
    ("(guint) OSTREE_REPO_LIST_OBJECTS_NO_PARENTS", "8"),
    ("(guint) OSTREE_REPO_LIST_OBJECTS_PACKED", "2"),
    ("(guint) OSTREE_REPO_LIST_REFS_EXT_ALIASES", "1"),
    ("(guint) OSTREE_REPO_LIST_REFS_EXT_EXCLUDE_MIRRORS", "4"),
    ("(guint) OSTREE_REPO_LIST_REFS_EXT_EXCLUDE_REMOTES", "2"),
    ("(guint) OSTREE_REPO_LIST_REFS_EXT_NONE", "0"),
    ("OSTREE_REPO_METADATA_REF", "ostree-metadata"),
    ("(gint) OSTREE_REPO_MODE_ARCHIVE", "1"),
    ("(gint) OSTREE_REPO_MODE_ARCHIVE_Z2", "1"),
    ("(gint) OSTREE_REPO_MODE_BARE", "0"),
    ("(gint) OSTREE_REPO_MODE_BARE_USER", "2"),
    ("(gint) OSTREE_REPO_MODE_BARE_USER_ONLY", "3"),
    ("(guint) OSTREE_REPO_PRUNE_FLAGS_NONE", "0"),
    ("(guint) OSTREE_REPO_PRUNE_FLAGS_NO_PRUNE", "1"),
    ("(guint) OSTREE_REPO_PRUNE_FLAGS_REFS_ONLY", "2"),
    ("(guint) OSTREE_REPO_PULL_FLAGS_BAREUSERONLY_FILES", "8"),
    ("(guint) OSTREE_REPO_PULL_FLAGS_COMMIT_ONLY", "2"),
    ("(guint) OSTREE_REPO_PULL_FLAGS_MIRROR", "1"),
    ("(guint) OSTREE_REPO_PULL_FLAGS_NONE", "0"),
    ("(guint) OSTREE_REPO_PULL_FLAGS_TRUSTED_HTTP", "16"),
    ("(guint) OSTREE_REPO_PULL_FLAGS_UNTRUSTED", "4"),
    ("(gint) OSTREE_REPO_REMOTE_CHANGE_ADD", "0"),
    ("(gint) OSTREE_REPO_REMOTE_CHANGE_ADD_IF_NOT_EXISTS", "1"),
    ("(gint) OSTREE_REPO_REMOTE_CHANGE_DELETE", "2"),
    ("(gint) OSTREE_REPO_REMOTE_CHANGE_DELETE_IF_EXISTS", "3"),
    ("(gint) OSTREE_REPO_REMOTE_CHANGE_REPLACE", "4"),
    ("(guint) OSTREE_REPO_RESOLVE_REV_EXT_LOCAL_ONLY", "1"),
    ("(guint) OSTREE_REPO_RESOLVE_REV_EXT_NONE", "0"),
    (
        "(guint) OSTREE_SEPOLICY_RESTORECON_FLAGS_ALLOW_NOLABEL",
        "1",
    ),
    (
        "(guint) OSTREE_SEPOLICY_RESTORECON_FLAGS_KEEP_EXISTING",
        "2",
    ),
    ("(guint) OSTREE_SEPOLICY_RESTORECON_FLAGS_NONE", "0"),
    ("OSTREE_SHA256_DIGEST_LEN", "32"),
    ("OSTREE_SHA256_STRING_LEN", "64"),
    ("OSTREE_SIGN_NAME_ED25519", "ed25519"),
    ("(gint) OSTREE_STATIC_DELTA_GENERATE_OPT_LOWLATENCY", "0"),
    ("(gint) OSTREE_STATIC_DELTA_GENERATE_OPT_MAJOR", "1"),
    ("(gint) OSTREE_STATIC_DELTA_INDEX_FLAGS_NONE", "0"),
    ("OSTREE_SUMMARY_GVARIANT_STRING", "(a(s(taya{sv}))a{sv})"),
    ("OSTREE_SUMMARY_SIG_GVARIANT_STRING", "a{sv}"),
    (
        "(guint) OSTREE_SYSROOT_SIMPLE_WRITE_DEPLOYMENT_FLAGS_NONE",
        "0",
    ),
    (
        "(guint) OSTREE_SYSROOT_SIMPLE_WRITE_DEPLOYMENT_FLAGS_NOT_DEFAULT",
        "2",
    ),
    (
        "(guint) OSTREE_SYSROOT_SIMPLE_WRITE_DEPLOYMENT_FLAGS_NO_CLEAN",
        "4",
    ),
    (
        "(guint) OSTREE_SYSROOT_SIMPLE_WRITE_DEPLOYMENT_FLAGS_RETAIN",
        "1",
    ),
    (
        "(guint) OSTREE_SYSROOT_SIMPLE_WRITE_DEPLOYMENT_FLAGS_RETAIN_PENDING",
        "8",
    ),
    (
        "(guint) OSTREE_SYSROOT_SIMPLE_WRITE_DEPLOYMENT_FLAGS_RETAIN_ROLLBACK",
        "16",
    ),
    (
        "(guint) OSTREE_SYSROOT_UPGRADER_FLAGS_IGNORE_UNCONFIGURED",
        "2",
    ),
    (
        "(guint) OSTREE_SYSROOT_UPGRADER_PULL_FLAGS_ALLOW_OLDER",
        "1",
    ),
    ("(guint) OSTREE_SYSROOT_UPGRADER_PULL_FLAGS_NONE", "0"),
    ("(guint) OSTREE_SYSROOT_UPGRADER_PULL_FLAGS_SYNTHETIC", "2"),
    ("OSTREE_TIMESTAMP", "0"),
    ("OSTREE_TREE_GVARIANT_STRING", "(a(say)a(sayay))"),
];
