mod calc;
mod config;
mod hiscore;
mod ping;
mod price;
mod wiki;

pub use self::config::*;
pub use calc::*;
pub use hiscore::*;
pub use ping::*;
pub use price::*;
pub use wiki::*;

use crate::utils::context::CommandContext;
use async_trait::async_trait;
use std::io::Write;

/// An enum that defines a list of subcommands.
pub trait CommandType<O: Write> {
    /// Get the command out of this wrapper variant.
    fn command(&self) -> &dyn Command<O>;
}

/// One subcommand for the CLI. Each command should also implement `StructOpt`,
/// so that it can collect its own CLI args.
// wasm bindgen futures don't impl Send/Sync, so we have to disable that bound.
// That's fine since our program is single threaded anyway.
#[async_trait(?Send)]
pub trait Command<O: Write> {
    /// Run the command with the given input options.
    async fn execute(&self, context: CommandContext<O>) -> anyhow::Result<()>
    // Need to ensure the output reference lives until the async stack is
    // resolved. The 'async_trait lifetime is generated by the macro.
    // https://github.com/dtolnay/async-trait/issues/8
    where
        O: 'async_trait;
}
