// Automatically generated rust module for 'fileformat.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Blob {
    pub raw: Option<Vec<u8>>,
    pub raw_size: Option<i32>,
    pub zlib_data: Option<Vec<u8>>,
    pub lzma_data: Option<Vec<u8>>,
}

impl<'a> MessageRead<'a> for Blob {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.raw = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(16) => msg.raw_size = Some(r.read_int32(bytes)?),
                Ok(26) => msg.zlib_data = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(34) => msg.lzma_data = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Blob {
    fn get_size(&self) -> usize {
        0
        + self.raw.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.raw_size.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.zlib_data.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.lzma_data.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.raw { w.write_with_tag(10, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.raw_size { w.write_with_tag(16, |w| w.write_int32(*s))?; }
        if let Some(ref s) = self.zlib_data { w.write_with_tag(26, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.lzma_data { w.write_with_tag(34, |w| w.write_bytes(&**s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct BlobHeader {
    pub type_pb: String,
    pub indexdata: Option<Vec<u8>>,
    pub datasize: i32,
}

impl<'a> MessageRead<'a> for BlobHeader {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.type_pb = r.read_string(bytes)?.to_owned(),
                Ok(18) => msg.indexdata = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(24) => msg.datasize = r.read_int32(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for BlobHeader {
    fn get_size(&self) -> usize {
        0
        + 1 + sizeof_len((&self.type_pb).len())
        + self.indexdata.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + 1 + sizeof_varint(*(&self.datasize) as u64)
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        w.write_with_tag(10, |w| w.write_string(&**&self.type_pb))?;
        if let Some(ref s) = self.indexdata { w.write_with_tag(18, |w| w.write_bytes(&**s))?; }
        w.write_with_tag(24, |w| w.write_int32(*&self.datasize))?;
        Ok(())
    }
}

