# Rust API client for ory-oathkeeper-client

ORY Oathkeeper is a reverse proxy that checks the HTTP Authorization for validity against a set of rules. This service uses Hydra to validate access tokens and policies.

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v0.38.12-beta.1
- Package version: v0.38.12-beta.1
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://www.ory.am](https://www.ory.am)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiApi* | [**decisions**](docs/ApiApi.md#decisions) | **get** /decisions | Access Control Decision API
*ApiApi* | [**get_rule**](docs/ApiApi.md#get_rule) | **get** /rules/{id} | Retrieve a rule
*ApiApi* | [**get_version**](docs/ApiApi.md#get_version) | **get** /version | Get service version
*ApiApi* | [**get_well_known_json_web_keys**](docs/ApiApi.md#get_well_known_json_web_keys) | **get** /.well-known/jwks.json | Lists cryptographic keys
*ApiApi* | [**is_instance_alive**](docs/ApiApi.md#is_instance_alive) | **get** /health/alive | Check alive status
*ApiApi* | [**is_instance_ready**](docs/ApiApi.md#is_instance_ready) | **get** /health/ready | Check readiness status
*ApiApi* | [**list_rules**](docs/ApiApi.md#list_rules) | **get** /rules | List all rules


## Documentation For Models

 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [JsonWebKey](docs/JsonWebKey.md)
 - [JsonWebKeySet](docs/JsonWebKeySet.md)
 - [Rule](docs/Rule.md)
 - [RuleHandler](docs/RuleHandler.md)
 - [RuleMatch](docs/RuleMatch.md)
 - [Upstream](docs/Upstream.md)
 - [Version](docs/Version.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

hi@ory.am

