# Rust API client for ory-oathkeeper-client

ORY Oathkeeper is a reverse proxy that checks the HTTP Authorization for validity against a set of rules. This service uses Hydra to validate access tokens and policies.

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v0.0.0-alpha.58
- Package version: v0.0.0-alpha.58
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://www.ory.am](https://www.ory.am)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiApi* | [**decisions**](docs/ApiApi.md#decisions) | **GET** /decisions | Access Control Decision API
*ApiApi* | [**get_rule**](docs/ApiApi.md#get_rule) | **GET** /rules/{id} | Retrieve a rule
*ApiApi* | [**get_version**](docs/ApiApi.md#get_version) | **GET** /version | Get service version
*ApiApi* | [**get_well_known_json_web_keys**](docs/ApiApi.md#get_well_known_json_web_keys) | **GET** /.well-known/jwks.json | Lists cryptographic keys
*ApiApi* | [**is_instance_alive**](docs/ApiApi.md#is_instance_alive) | **GET** /health/alive | Check alive status
*ApiApi* | [**is_instance_ready**](docs/ApiApi.md#is_instance_ready) | **GET** /health/ready | Check readiness status
*ApiApi* | [**list_rules**](docs/ApiApi.md#list_rules) | **GET** /rules | List all rules


## Documentation For Models

 - [CreateRuleCreated](docs/CreateRuleCreated.md)
 - [CreateRuleForbidden](docs/CreateRuleForbidden.md)
 - [CreateRuleForbiddenBody](docs/CreateRuleForbiddenBody.md)
 - [CreateRuleInternalServerError](docs/CreateRuleInternalServerError.md)
 - [CreateRuleInternalServerErrorBody](docs/CreateRuleInternalServerErrorBody.md)
 - [CreateRuleUnauthorized](docs/CreateRuleUnauthorized.md)
 - [CreateRuleUnauthorizedBody](docs/CreateRuleUnauthorizedBody.md)
 - [DecisionsForbidden](docs/DecisionsForbidden.md)
 - [DecisionsForbiddenBody](docs/DecisionsForbiddenBody.md)
 - [DecisionsInternalServerError](docs/DecisionsInternalServerError.md)
 - [DecisionsInternalServerErrorBody](docs/DecisionsInternalServerErrorBody.md)
 - [DecisionsNotFound](docs/DecisionsNotFound.md)
 - [DecisionsNotFoundBody](docs/DecisionsNotFoundBody.md)
 - [DecisionsUnauthorized](docs/DecisionsUnauthorized.md)
 - [DecisionsUnauthorizedBody](docs/DecisionsUnauthorizedBody.md)
 - [DeleteRuleForbidden](docs/DeleteRuleForbidden.md)
 - [DeleteRuleForbiddenBody](docs/DeleteRuleForbiddenBody.md)
 - [DeleteRuleInternalServerError](docs/DeleteRuleInternalServerError.md)
 - [DeleteRuleInternalServerErrorBody](docs/DeleteRuleInternalServerErrorBody.md)
 - [DeleteRuleNotFound](docs/DeleteRuleNotFound.md)
 - [DeleteRuleNotFoundBody](docs/DeleteRuleNotFoundBody.md)
 - [DeleteRuleUnauthorized](docs/DeleteRuleUnauthorized.md)
 - [DeleteRuleUnauthorizedBody](docs/DeleteRuleUnauthorizedBody.md)
 - [GetRuleForbidden](docs/GetRuleForbidden.md)
 - [GetRuleForbiddenBody](docs/GetRuleForbiddenBody.md)
 - [GetRuleInternalServerError](docs/GetRuleInternalServerError.md)
 - [GetRuleInternalServerErrorBody](docs/GetRuleInternalServerErrorBody.md)
 - [GetRuleNotFound](docs/GetRuleNotFound.md)
 - [GetRuleNotFoundBody](docs/GetRuleNotFoundBody.md)
 - [GetRuleOk](docs/GetRuleOk.md)
 - [GetRuleUnauthorized](docs/GetRuleUnauthorized.md)
 - [GetRuleUnauthorizedBody](docs/GetRuleUnauthorizedBody.md)
 - [GetWellKnownForbidden](docs/GetWellKnownForbidden.md)
 - [GetWellKnownForbiddenBody](docs/GetWellKnownForbiddenBody.md)
 - [GetWellKnownJsonWebKeysInternalServerError](docs/GetWellKnownJsonWebKeysInternalServerError.md)
 - [GetWellKnownJsonWebKeysInternalServerErrorBody](docs/GetWellKnownJsonWebKeysInternalServerErrorBody.md)
 - [GetWellKnownJsonWebKeysOk](docs/GetWellKnownJsonWebKeysOk.md)
 - [GetWellKnownOk](docs/GetWellKnownOk.md)
 - [GetWellKnownUnauthorized](docs/GetWellKnownUnauthorized.md)
 - [GetWellKnownUnauthorizedBody](docs/GetWellKnownUnauthorizedBody.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [IsInstanceAliveInternalServerError](docs/IsInstanceAliveInternalServerError.md)
 - [IsInstanceAliveInternalServerErrorBody](docs/IsInstanceAliveInternalServerErrorBody.md)
 - [IsInstanceAliveOk](docs/IsInstanceAliveOk.md)
 - [JsonWebKey](docs/JsonWebKey.md)
 - [JsonWebKeySet](docs/JsonWebKeySet.md)
 - [JudgeForbidden](docs/JudgeForbidden.md)
 - [JudgeForbiddenBody](docs/JudgeForbiddenBody.md)
 - [JudgeInternalServerError](docs/JudgeInternalServerError.md)
 - [JudgeInternalServerErrorBody](docs/JudgeInternalServerErrorBody.md)
 - [JudgeNotFound](docs/JudgeNotFound.md)
 - [JudgeNotFoundBody](docs/JudgeNotFoundBody.md)
 - [JudgeUnauthorized](docs/JudgeUnauthorized.md)
 - [JudgeUnauthorizedBody](docs/JudgeUnauthorizedBody.md)
 - [ListRulesForbidden](docs/ListRulesForbidden.md)
 - [ListRulesForbiddenBody](docs/ListRulesForbiddenBody.md)
 - [ListRulesInternalServerError](docs/ListRulesInternalServerError.md)
 - [ListRulesInternalServerErrorBody](docs/ListRulesInternalServerErrorBody.md)
 - [ListRulesOk](docs/ListRulesOk.md)
 - [ListRulesUnauthorized](docs/ListRulesUnauthorized.md)
 - [ListRulesUnauthorizedBody](docs/ListRulesUnauthorizedBody.md)
 - [Rule](docs/Rule.md)
 - [RuleHandler](docs/RuleHandler.md)
 - [RuleMatch](docs/RuleMatch.md)
 - [SwaggerCreateRuleParameters](docs/SwaggerCreateRuleParameters.md)
 - [SwaggerGetRuleParameters](docs/SwaggerGetRuleParameters.md)
 - [SwaggerHealthStatus](docs/SwaggerHealthStatus.md)
 - [SwaggerJsonWebKey](docs/SwaggerJsonWebKey.md)
 - [SwaggerJsonWebKeySet](docs/SwaggerJsonWebKeySet.md)
 - [SwaggerListRulesParameters](docs/SwaggerListRulesParameters.md)
 - [SwaggerNotReadyStatus](docs/SwaggerNotReadyStatus.md)
 - [SwaggerRule](docs/SwaggerRule.md)
 - [SwaggerRuleHandler](docs/SwaggerRuleHandler.md)
 - [SwaggerRuleMatch](docs/SwaggerRuleMatch.md)
 - [SwaggerRuleResponse](docs/SwaggerRuleResponse.md)
 - [SwaggerRulesResponse](docs/SwaggerRulesResponse.md)
 - [SwaggerUpdateRuleParameters](docs/SwaggerUpdateRuleParameters.md)
 - [SwaggerVersion](docs/SwaggerVersion.md)
 - [UpdateRuleForbidden](docs/UpdateRuleForbidden.md)
 - [UpdateRuleForbiddenBody](docs/UpdateRuleForbiddenBody.md)
 - [UpdateRuleInternalServerError](docs/UpdateRuleInternalServerError.md)
 - [UpdateRuleInternalServerErrorBody](docs/UpdateRuleInternalServerErrorBody.md)
 - [UpdateRuleNotFound](docs/UpdateRuleNotFound.md)
 - [UpdateRuleNotFoundBody](docs/UpdateRuleNotFoundBody.md)
 - [UpdateRuleOk](docs/UpdateRuleOk.md)
 - [UpdateRuleUnauthorized](docs/UpdateRuleUnauthorized.md)
 - [UpdateRuleUnauthorizedBody](docs/UpdateRuleUnauthorizedBody.md)
 - [Upstream](docs/Upstream.md)
 - [Version](docs/Version.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

hi@ory.am

