# Rust API client for ory-keto-client

Documentation for all of Ory Keto's REST APIs. gRPC is documented separately.


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v0.8.0-alpha.2
- Package version: v0.8.0-alpha.2
- Build package: org.openapitools.codegen.languages.RustClientCodegen

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MetadataApi* | [**get_version**](docs/MetadataApi.md#get_version) | **GET** /version | Return Running Software Version.
*MetadataApi* | [**is_alive**](docs/MetadataApi.md#is_alive) | **GET** /health/alive | Check HTTP Server Status
*MetadataApi* | [**is_ready**](docs/MetadataApi.md#is_ready) | **GET** /health/ready | Check HTTP Server and Database Status
*ReadApi* | [**get_check**](docs/ReadApi.md#get_check) | **GET** /check | Check a relation tuple
*ReadApi* | [**get_expand**](docs/ReadApi.md#get_expand) | **GET** /expand | Expand a Relation Tuple
*ReadApi* | [**get_relation_tuples**](docs/ReadApi.md#get_relation_tuples) | **GET** /relation-tuples | Query relation tuples
*ReadApi* | [**post_check**](docs/ReadApi.md#post_check) | **POST** /check | Check a relation tuple
*WriteApi* | [**create_relation_tuple**](docs/WriteApi.md#create_relation_tuple) | **PUT** /relation-tuples | Create a Relation Tuple
*WriteApi* | [**delete_relation_tuples**](docs/WriteApi.md#delete_relation_tuples) | **DELETE** /relation-tuples | Delete Relation Tuples
*WriteApi* | [**patch_relation_tuples**](docs/WriteApi.md#patch_relation_tuples) | **PATCH** /relation-tuples | Patch Multiple Relation Tuples


## Documentation For Models

 - [ExpandTree](docs/ExpandTree.md)
 - [GenericError](docs/GenericError.md)
 - [GetCheckResponse](docs/GetCheckResponse.md)
 - [GetRelationTuplesResponse](docs/GetRelationTuplesResponse.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InternalRelationTuple](docs/InternalRelationTuple.md)
 - [PatchDelta](docs/PatchDelta.md)
 - [RelationQuery](docs/RelationQuery.md)
 - [SubjectSet](docs/SubjectSet.md)
 - [Version](docs/Version.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

hi@ory.sh

