/*
 * ORY Keto
 *
 * Ory Keto is a cloud native access control server providing best-practice patterns (RBAC, ABAC, ACL, AWS IAM Policies, Kubernetes Roles, ...) via REST APIs.
 *
 * The version of the OpenAPI document: v0.0.0-alpha.58
 * Contact: hi@ory.sh
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct OryAccessControlPolicy {
    /// Actions is an array representing all the actions this ORY Access Policy applies to.
    #[serde(rename = "actions", skip_serializing_if = "Option::is_none")]
    pub actions: Option<Vec<String>>,
    /// Conditions represents a keyed object of conditions under which this ORY Access Policy is active.
    #[serde(rename = "conditions", skip_serializing_if = "Option::is_none")]
    pub conditions: Option<serde_json::Value>,
    /// Description is an optional, human-readable description.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// Effect is the effect of this ORY Access Policy. It can be \"allow\" or \"deny\".
    #[serde(rename = "effect", skip_serializing_if = "Option::is_none")]
    pub effect: Option<String>,
    /// ID is the unique identifier of the ORY Access Policy. It is used to query, update, and remove the ORY Access Policy.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Resources is an array representing all the resources this ORY Access Policy applies to.
    #[serde(rename = "resources", skip_serializing_if = "Option::is_none")]
    pub resources: Option<Vec<String>>,
    /// Subjects is an array representing all the subjects this ORY Access Policy applies to.
    #[serde(rename = "subjects", skip_serializing_if = "Option::is_none")]
    pub subjects: Option<Vec<String>>,
}

impl OryAccessControlPolicy {
    pub fn new() -> OryAccessControlPolicy {
        OryAccessControlPolicy {
            actions: None,
            conditions: None,
            description: None,
            effect: None,
            id: None,
            resources: None,
            subjects: None,
        }
    }
}


